/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.weld.ejb.StatefulSessionObjectReferenceImpl;
import org.jboss.ejb.client.SessionID;
import org.jboss.msc.service.ServiceName;

public class SerializedStatefulSessionObject
implements Serializable {
    private final String componentServiceName;
    private final SessionID sessionID;
    private final Map<String, String> serviceNames;

    public SerializedStatefulSessionObject(ServiceName componentServiceName, SessionID sessionID, Map<String, ServiceName> serviceNames) {
        this.componentServiceName = componentServiceName.getCanonicalName();
        this.sessionID = sessionID;
        HashMap<String, String> names = new HashMap<String, String>();
        for (Map.Entry<String, ServiceName> e : serviceNames.entrySet()) {
            names.put(e.getKey(), e.getValue().getCanonicalName());
        }
        this.serviceNames = names;
    }

    private Object readResolve() throws ObjectStreamException {
        HashMap<String, ServiceName> names = new HashMap<String, ServiceName>();
        for (Map.Entry<String, String> e : this.serviceNames.entrySet()) {
            names.put(e.getKey(), ServiceName.parse((String)e.getValue()));
        }
        return new StatefulSessionObjectReferenceImpl(this.sessionID, ServiceName.parse((String)this.componentServiceName), names);
    }
}

