/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.BaseCondition;

abstract class BooleanCondition
extends BaseCondition {
    private BaseCondition leftCondition;
    private BaseCondition rightCondition;

    public BooleanCondition(BaseCondition leftCondition, BaseCondition rightCondition) {
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
    }

    public BaseCondition getFirstCondition() {
        return this.leftCondition;
    }

    public BaseCondition getSecondCondition() {
        return this.rightCondition;
    }

    public void replaceChildCondition(BaseCondition oldChild, BaseCondition newChild) {
        if (this.leftCondition == oldChild) {
            this.leftCondition = newChild;
        } else if (this.rightCondition == oldChild) {
            this.rightCondition = newChild;
        } else {
            throw new IllegalStateException("Old child condition not found in parent");
        }
        newChild.setParent(this);
    }

    @Override
    void setQueryBuilder(QueryBuilder queryBuilder) {
        super.setQueryBuilder(queryBuilder);
        if (this.leftCondition != null) {
            this.leftCondition.setQueryBuilder(queryBuilder);
        }
        if (this.rightCondition != null) {
            this.rightCondition.setQueryBuilder(queryBuilder);
        }
    }
}

