/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core.supplier;

import junit.framework.Assert;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddLookupTableChange;
import liquibase.change.core.CreateTableChange;
import liquibase.diff.DiffResult;
import liquibase.exception.DatabaseException;
import liquibase.sdk.supplier.change.AbstractChangeSupplier;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Table;

public class AddLookupTableChangeSupplier
extends AbstractChangeSupplier<AddLookupTableChange> {
    public AddLookupTableChangeSupplier() {
        super(AddLookupTableChange.class);
    }

    @Override
    public Change[] prepareDatabase(AddLookupTableChange change) throws DatabaseException {
        CreateTableChange createTableChange = new CreateTableChange();
        createTableChange.setCatalogName(change.getExistingTableCatalogName());
        createTableChange.setSchemaName(change.getExistingTableSchemaName());
        createTableChange.setTableName(change.getExistingTableName());
        createTableChange.addColumn(new ColumnConfig().setName("other_column").setType("int"));
        createTableChange.addColumn(new ColumnConfig().setName(change.getExistingColumnName()).setType(change.getNewColumnDataType()));
        return new Change[]{createTableChange};
    }

    @Override
    public void checkDiffResult(DiffResult diffResult, AddLookupTableChange change) {
        Table newTable = diffResult.getUnexpectedObject(new Table(change.getNewTableCatalogName(), change.getNewTableSchemaName(), change.getNewTableName()));
        Assert.assertNotNull((Object)newTable);
        Assert.assertEquals((int)1, (int)newTable.getColumns().size());
        Assert.assertNotNull((Object)newTable.getColumn(change.getNewColumnName()));
        Assert.assertEquals((String)change.getNewColumnName().toUpperCase(), (String)newTable.getPrimaryKey().getColumnNames().toUpperCase());
        Assert.assertNotNull((Object)diffResult.getUnexpectedObject(new Table(change.getNewTableCatalogName(), change.getNewTableSchemaName(), change.getNewTableName())));
        Assert.assertNotNull((Object)new ForeignKey(change.getConstraintName(), change.getExistingTableCatalogName(), change.getExistingTableSchemaName(), change.getExistingTableName(), change.getExistingColumnName()));
    }
}

