/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StringUtils;

public class ClassLoaderResourceAccessor
extends AbstractResourceAccessor {
    private ClassLoader classLoader;

    public ClassLoaderResourceAccessor() {
        this.classLoader = this.getClass().getClassLoader();
        this.init();
    }

    public ClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init();
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        Enumeration<URL> resources = this.classLoader.getResources(path);
        if (resources == null || !resources.hasMoreElements()) {
            return null;
        }
        HashSet<String> seenUrls = new HashSet<String>();
        HashSet<InputStream> returnSet = new HashSet<InputStream>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (seenUrls.contains(url.toExternalForm())) continue;
            seenUrls.add(url.toExternalForm());
            InputStream resourceAsStream = url.openStream();
            if (resourceAsStream == null) continue;
            returnSet.add(resourceAsStream);
        }
        return returnSet;
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        HashSet<String> returnSet;
        Object file;
        URL fileUrl = this.classLoader.getResource(path = this.convertToPath(relativeTo, path));
        if (fileUrl == null) {
            return null;
        }
        if (!fileUrl.toExternalForm().startsWith("file:") && (fileUrl.toExternalForm().startsWith("jar:file:") || fileUrl.toExternalForm().startsWith("wsjar:file:") || fileUrl.toExternalForm().startsWith("zip:"))) {
            file = fileUrl.getFile();
            String splitPath = ((String)file).split("!")[0];
            splitPath = splitPath.matches("file:\\/[A-Za-z]:\\/.*") ? splitPath.replaceFirst("file:\\/", "") : splitPath.replaceFirst("file:", "");
            splitPath = URLDecoder.decode(splitPath, "UTF-8");
            File zipfile = new File(splitPath);
            File zipFileDir = FileUtil.unzip(zipfile);
            if (path.startsWith("classpath:")) {
                path = path.replaceFirst("classpath:", "");
            }
            if (path.startsWith("classpath*:")) {
                path = path.replaceFirst("classpath\\*:", "");
            }
            URI fileUri = new File(zipFileDir, path).toURI();
            fileUrl = fileUri.toURL();
        }
        try {
            file = new File(fileUrl.toURI());
            if (((File)file).exists()) {
                returnSet = new HashSet<String>();
                this.getContents((File)file, recursive, includeFiles, includeDirectories, path, returnSet);
                return returnSet;
            }
        }
        catch (URISyntaxException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Enumeration<URL> resources = this.classLoader.getResources(path);
        if (resources == null || !resources.hasMoreElements()) {
            return null;
        }
        returnSet = new HashSet();
        while (resources.hasMoreElements()) {
            String url = resources.nextElement().toExternalForm();
            url = url.replaceFirst("^\\Q" + path + "\\E", "");
            returnSet.add(url);
        }
        return returnSet;
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String description;
        if (this.classLoader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this.classLoader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.classLoader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

