/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class DelegatingURLConnection
extends URLConnection {
    protected URL delegateUrl;
    protected URLConnection delegateConnection;

    public DelegatingURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
        this.delegateUrl = this.makeDelegateUrl(url);
        this.delegateConnection = this.makeDelegateUrlConnection(this.delegateUrl);
    }

    protected URL makeDelegateUrl(URL url) throws MalformedURLException, IOException {
        return url;
    }

    protected URLConnection makeDelegateUrlConnection(URL url) throws IOException {
        return url.openConnection();
    }

    @Override
    public void connect() throws IOException {
        this.delegateConnection.connect();
    }

    @Override
    public URL getURL() {
        return this.delegateConnection.getURL();
    }

    @Override
    public int getContentLength() {
        return this.delegateConnection.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.delegateConnection.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.delegateConnection.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        return this.delegateConnection.getExpiration();
    }

    @Override
    public long getDate() {
        return this.delegateConnection.getDate();
    }

    @Override
    public long getLastModified() {
        return this.delegateConnection.getLastModified();
    }

    @Override
    public String getHeaderField(String name) {
        return this.delegateConnection.getHeaderField(name);
    }

    @Override
    public int getHeaderFieldInt(String name, int _default) {
        return this.delegateConnection.getHeaderFieldInt(name, _default);
    }

    @Override
    public long getHeaderFieldDate(String name, long _default) {
        return this.delegateConnection.getHeaderFieldDate(name, _default);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.delegateConnection.getHeaderFieldKey(n);
    }

    @Override
    public String getHeaderField(int n) {
        return this.delegateConnection.getHeaderField(n);
    }

    @Override
    public Object getContent() throws IOException {
        return this.delegateConnection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.delegateConnection.getContent(classes);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.delegateConnection.getPermission();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegateConnection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegateConnection.getOutputStream();
    }

    @Override
    public String toString() {
        return super.toString() + "{ " + this.delegateConnection + " }";
    }

    @Override
    public void setDoInput(boolean doinput) {
        this.delegateConnection.setDoInput(doinput);
    }

    @Override
    public boolean getDoInput() {
        return this.delegateConnection.getDoInput();
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.delegateConnection.setDoOutput(dooutput);
    }

    @Override
    public boolean getDoOutput() {
        return this.delegateConnection.getDoOutput();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.delegateConnection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.delegateConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.delegateConnection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.delegateConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.delegateConnection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public long getIfModifiedSince() {
        return this.delegateConnection.getIfModifiedSince();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.delegateConnection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.delegateConnection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.delegateConnection.setRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.delegateConnection.getRequestProperty(key);
    }
}

