/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.remoting3.Connection;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(String moduleSpec) throws ModuleLoadException {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleSpec));
        return WildFlySecurityManager.isChecking() ? (ModuleClassLoader)AccessController.doPrivileged(new GetModuleClassLoaderAction(module)) : module.getClassLoader();
    }

    static Class<?> loadClass(final String name) throws ClassNotFoundException {
        if (WildFlySecurityManager.isChecking()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        ClassLoader[] cls = new ClassLoader[]{SecurityActions.class.getClassLoader(), WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), ClassLoader.getSystemClassLoader()};
                        ClassNotFoundException e = null;
                        for (ClassLoader cl : cls) {
                            if (cl == null) continue;
                            try {
                                return cl.loadClass(name);
                            }
                            catch (ClassNotFoundException ce) {
                                e = ce;
                            }
                        }
                        throw e != null ? e : SecurityMessages.MESSAGES.cnfe(name);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw SecurityMessages.MESSAGES.cnfeThrow(name, pae);
            }
        }
        ClassLoader[] cls = new ClassLoader[]{SecurityActions.class.getClassLoader(), WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), ClassLoader.getSystemClassLoader()};
        ClassNotFoundException e = null;
        for (ClassLoader cl : cls) {
            if (cl == null) continue;
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException ce) {
                e = ce;
            }
        }
        throw e != null ? e : SecurityMessages.MESSAGES.cnfe(name);
    }

    static void remotingContextClear() {
        SecurityActions.remotingContextAccociationActions().clear();
    }

    static Connection remotingContextGetConnection() {
        return SecurityActions.remotingContextAccociationActions().getConnection();
    }

    static boolean remotingContextIsSet() {
        return SecurityActions.remotingContextAccociationActions().isSet();
    }

    private static RemotingContextAssociationActions remotingContextAccociationActions() {
        return !WildFlySecurityManager.isChecking() ? RemotingContextAssociationActions.NON_PRIVILEGED : RemotingContextAssociationActions.PRIVILEGED;
    }

    static Policy getPolicy() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                @Override
                public Policy run() {
                    return Policy.getPolicy();
                }
            });
        }
        return Policy.getPolicy();
    }

    private static interface RemotingContextAssociationActions {
        public static final RemotingContextAssociationActions NON_PRIVILEGED = new RemotingContextAssociationActions(){

            @Override
            public boolean isSet() {
                return RemotingContext.isSet();
            }

            @Override
            public Connection getConnection() {
                return RemotingContext.getConnection();
            }

            @Override
            public void clear() {
                RemotingContext.clear();
            }
        };
        public static final RemotingContextAssociationActions PRIVILEGED = new RemotingContextAssociationActions(){
            private final PrivilegedAction<Boolean> IS_SET_ACTION = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return NON_PRIVILEGED.isSet();
                }
            };
            private final PrivilegedAction<Connection> GET_CONNECTION_ACTION = new PrivilegedAction<Connection>(){

                @Override
                public Connection run() {
                    return NON_PRIVILEGED.getConnection();
                }
            };
            private final PrivilegedAction<Void> CLEAR_ACTION = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    NON_PRIVILEGED.clear();
                    return null;
                }
            };

            @Override
            public boolean isSet() {
                return AccessController.doPrivileged(this.IS_SET_ACTION);
            }

            @Override
            public Connection getConnection() {
                return AccessController.doPrivileged(this.GET_CONNECTION_ACTION);
            }

            @Override
            public void clear() {
                AccessController.doPrivileged(this.CLEAR_ACTION);
            }
        };

        public Connection getConnection();

        public boolean isSet();

        public void clear();
    }
}

