/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.ba.remote;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mwlabs.wst.ba.remote.ContextManager;
import com.arjuna.mwlabs.wst11.ba.context.TxContextImple;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.BusinessActivityConstants;
import com.arjuna.webservices11.wsba.processors.CoordinatorCompletionParticipantProcessor;
import com.arjuna.webservices11.wsba.processors.ParticipantCompletionParticipantProcessor;
import com.arjuna.wsc.CannotRegisterException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import com.arjuna.wsc.NoActivityException;
import com.arjuna.wsc11.RegistrationCoordinator;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.BusinessAgreementWithCoordinatorCompletionParticipant;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import com.arjuna.wst11.messaging.engines.CoordinatorCompletionParticipantEngine;
import com.arjuna.wst11.messaging.engines.ParticipantCompletionParticipantEngine;
import com.arjuna.wst11.stub.BACoordinatorCompletionParticipantManagerStub;
import com.arjuna.wst11.stub.BAParticipantCompletionParticipantManagerStub;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;

public class BusinessActivityManagerImple
extends BusinessActivityManager {
    private ContextManager _ctxManager = new ContextManager();

    @Override
    public BAParticipantManager enlistForBusinessAgreementWithParticipantCompletion(BusinessAgreementWithParticipantCompletionParticipant bap, String id) throws WrongStateException, UnknownTransactionException, SystemException {
        QName service = BusinessActivityConstants.PARTICIPANT_COMPLETION_PARTICIPANT_SERVICE_QNAME;
        QName endpoint = BusinessActivityConstants.PARTICIPANT_COMPLETION_PARTICIPANT_PORT_QNAME;
        try {
            boolean isSecure = ((TxContextImple)this.currentTransaction()).isSecure();
            String address = ServiceRegistry.getRegistry().getServiceURI("BusinessAgreementWithParticipantCompletionParticipantService", isSecure);
            W3CEndpointReference participant = this.getParticipant(service, endpoint, address, id);
            W3CEndpointReference baPMEndpoint = this.registerParticipant(participant, "http://docs.oasis-open.org/ws-tx/wsba/2006/06/ParticipantCompletion");
            ParticipantCompletionParticipantEngine engine = new ParticipantCompletionParticipantEngine(id, baPMEndpoint, bap);
            ParticipantCompletionParticipantProcessor.getProcessor().activateParticipant(engine, id);
            return new BAParticipantCompletionParticipantManagerStub(engine);
        }
        catch (InvalidProtocolException ex) {
            throw new SystemException(ex.toString());
        }
        catch (InvalidStateException ex) {
            throw new WrongStateException();
        }
        catch (CannotRegisterException ex) {
            throw new UnknownTransactionException();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public BAParticipantManager enlistForBusinessAgreementWithCoordinatorCompletion(BusinessAgreementWithCoordinatorCompletionParticipant bawcp, String id) throws WrongStateException, UnknownTransactionException, SystemException {
        QName service = BusinessActivityConstants.COORDINATOR_COMPLETION_PARTICIPANT_SERVICE_QNAME;
        QName endpoint = BusinessActivityConstants.COORDINATOR_COMPLETION_PARTICIPANT_PORT_QNAME;
        boolean isSecure = ((TxContextImple)this.currentTransaction()).isSecure();
        try {
            String address = ServiceRegistry.getRegistry().getServiceURI("BusinessAgreementWithCoordinatorCompletionParticipantService", isSecure);
            W3CEndpointReference participant = this.getParticipant(service, endpoint, address, id);
            W3CEndpointReference baPMEndpoint = this.registerParticipant(participant, "http://docs.oasis-open.org/ws-tx/wsba/2006/06/CoordinatorCompletion");
            CoordinatorCompletionParticipantEngine engine = new CoordinatorCompletionParticipantEngine(id, baPMEndpoint, bawcp);
            CoordinatorCompletionParticipantProcessor.getProcessor().activateParticipant(engine, id);
            return new BACoordinatorCompletionParticipantManagerStub(engine);
        }
        catch (InvalidProtocolException ex) {
            throw new SystemException(ex.toString());
        }
        catch (InvalidStateException ex) {
            throw new WrongStateException();
        }
        catch (CannotRegisterException ex) {
            ex.printStackTrace();
            throw new UnknownTransactionException();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public TxContext suspend() throws SystemException {
        return this._ctxManager.suspend();
    }

    @Override
    public void resume(TxContext tx) throws UnknownTransactionException, SystemException {
        this._ctxManager.resume(tx);
    }

    @Override
    public TxContext currentTransaction() throws SystemException {
        return this._ctxManager.currentTransaction();
    }

    private final W3CEndpointReference registerParticipant(W3CEndpointReference participant, String protocol) throws InvalidProtocolException, InvalidStateException, CannotRegisterException, SystemException {
        TxContextImple currentTx = null;
        try {
            currentTx = (TxContextImple)this._ctxManager.currentTransaction();
            if (currentTx == null) {
                throw new NoActivityException();
            }
            CoordinationContextType coordinationContext = currentTx.context().getCoordinationContext();
            String messageId = MessageId.getMessageId();
            W3CEndpointReference w3CEndpointReference = RegistrationCoordinator.register(coordinationContext, messageId, participant, protocol);
            return w3CEndpointReference;
        }
        catch (SoapFault sf) {
            throw new SystemException(sf.getMessage());
        }
        catch (CannotRegisterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException(ex.toString());
        }
        finally {
            try {
                if (currentTx != null) {
                    this._ctxManager.resume(currentTx);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private W3CEndpointReference getParticipant(QName service, QName endpoint, String address, String id) {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.serviceName(service);
        builder.endpointName(endpoint);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier(builder, id);
        return builder.build();
    }
}

