/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol;

import java.io.IOException;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.client.ejb.EJBClientHandler;
import org.jboss.naming.remote.protocol.v1.VersionOne;
import org.jboss.naming.remote.server.RemoteNamingServer;
import org.jboss.naming.remote.server.RemoteNamingService;
import org.jboss.remoting3.Channel;

public class Versions {
    private Versions() {
    }

    public static byte[] getSupportedVersions() {
        return new byte[]{VersionOne.getVersionIdentifier()};
    }

    public static RemoteNamingStore getRemoteNamingStore(byte version, Channel channel) throws IOException {
        return Versions.getRemoteNamingStore(version, channel, null);
    }

    public static RemoteNamingStore getRemoteNamingStore(byte version, Channel channel, EJBClientHandler ejbClientHandler) throws IOException {
        if (version == VersionOne.getVersionIdentifier()) {
            return VersionOne.getRemoteNamingStore(channel, ejbClientHandler);
        }
        throw new IllegalArgumentException("Unsupported protocol version [" + version + "]");
    }

    public static RemoteNamingServer getRemoteNamingServer(byte version, Channel channel, RemoteNamingService remoteNamingServer) {
        if (version == VersionOne.getVersionIdentifier()) {
            return VersionOne.getNamingServer(channel, remoteNamingServer);
        }
        throw new IllegalArgumentException("Unsupported protocol version [" + version + "]");
    }
}

