/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingConstants;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.impl.AddressingConstantsImpl;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.v200702.ObjectFactory;

public final class RMUtils {
    private static final ObjectFactory WSRM_FACTORY;
    private static final org.apache.cxf.ws.rm.v200502.ObjectFactory WSRM200502_FACTORY;
    private static final org.apache.cxf.ws.rm.v200502wsa15.ObjectFactory WSRM200502_WSA200508_FACTORY;
    private static final AddressingConstants WSA_CONSTANTS;
    private static final Pattern GENERATED_BUS_ID_PATTERN;

    private RMUtils() {
    }

    public static ObjectFactory getWSRMFactory() {
        return WSRM_FACTORY;
    }

    public static org.apache.cxf.ws.rm.v200502.ObjectFactory getWSRM200502Factory() {
        return WSRM200502_FACTORY;
    }

    public static org.apache.cxf.ws.rm.v200502wsa15.ObjectFactory getWSRM200502WSA200508Factory() {
        return WSRM200502_WSA200508_FACTORY;
    }

    public static RMConstants getConstants(String uri) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(uri)) {
            return RM10Constants.INSTANCE;
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(uri)) {
            return RM11Constants.INSTANCE;
        }
        return null;
    }

    public static AddressingConstants getAddressingConstants() {
        return WSA_CONSTANTS;
    }

    public static EndpointReferenceType createAnonymousReference() {
        return RMUtils.createReference("http://www.w3.org/2005/08/addressing/anonymous");
    }

    public static EndpointReferenceType createNoneReference() {
        return RMUtils.createReference("http://www.w3.org/2005/08/addressing/none");
    }

    public static EndpointReferenceType createReference(String address) {
        org.apache.cxf.ws.addressing.ObjectFactory factory = new org.apache.cxf.ws.addressing.ObjectFactory();
        EndpointReferenceType epr = factory.createEndpointReferenceType();
        AttributedURIType uri = factory.createAttributedURIType();
        uri.setValue(address);
        epr.setAddress(uri);
        return epr;
    }

    public static String getEndpointIdentifier(Endpoint endpoint) {
        return RMUtils.getEndpointIdentifier(endpoint, null);
    }

    public static String getEndpointIdentifier(Endpoint endpoint, Bus bus) {
        String busId = null;
        if (bus == null) {
            busId = "cxf";
        } else {
            busId = bus.getId();
            Matcher m = GENERATED_BUS_ID_PATTERN.matcher(busId);
            if (m.find()) {
                busId = busId.substring(0, m.start() + "cxf".length());
            }
        }
        return endpoint.getEndpointInfo().getService().getName() + "." + endpoint.getEndpointInfo().getName() + "@" + busId;
    }

    public static WriteOnCloseOutputStream createCachedStream(Message message, OutputStream os) {
        if (!(os instanceof WriteOnCloseOutputStream)) {
            WriteOnCloseOutputStream cached = new WriteOnCloseOutputStream(os);
            message.setContent(OutputStream.class, (Object)cached);
            os = cached;
        }
        return (WriteOnCloseOutputStream)os;
    }

    public static ObjectName getManagedObjectName(RMManager manager) throws JMException {
        StringBuilder buffer = new StringBuilder();
        RMUtils.writeTypeProperty(buffer, manager.getBus(), "WSRM.Manager");
        buffer.append(',').append("instance.id").append('=').append(manager.hashCode());
        return new ObjectName(buffer.toString());
    }

    public static ObjectName getManagedObjectName(RMEndpoint endpoint) throws JMException {
        StringBuilder buffer = new StringBuilder();
        RMUtils.writeTypeProperty(buffer, endpoint.getManager().getBus(), "WSRM.Endpoint");
        Endpoint ep = endpoint.getApplicationEndpoint();
        RMUtils.writeEndpointProperty(buffer, ep);
        return new ObjectName(buffer.toString());
    }

    public static ObjectName getManagedObjectName(RMManager manager, Endpoint ep) throws JMException {
        StringBuilder buffer = new StringBuilder();
        RMUtils.writeTypeProperty(buffer, manager.getBus(), "WSRM.Endpoint");
        RMUtils.writeEndpointProperty(buffer, ep);
        return new ObjectName(buffer.toString());
    }

    private static void writeTypeProperty(StringBuilder buffer, Bus bus, String type) {
        String busId = bus.getId();
        buffer.append("org.apache.cxf").append(':');
        buffer.append("bus.id").append('=').append(busId).append(',');
        buffer.append("type").append('=').append(type);
    }

    private static void writeEndpointProperty(StringBuilder buffer, Endpoint ep) {
        String serviceName = ObjectName.quote(ep.getService().getName().toString());
        buffer.append(",");
        buffer.append("service").append('=').append(serviceName).append(',');
        String endpointName = ObjectName.quote(ep.getEndpointInfo().getName().toString());
        buffer.append("port").append('=').append(endpointName).append(',');
        buffer.append("instance.id").append('=').append(ep.hashCode());
    }

    static {
        GENERATED_BUS_ID_PATTERN = Pattern.compile("cxf\\d+$");
        WSRM_FACTORY = new ObjectFactory();
        WSRM200502_FACTORY = new org.apache.cxf.ws.rm.v200502.ObjectFactory();
        WSRM200502_WSA200508_FACTORY = new org.apache.cxf.ws.rm.v200502wsa15.ObjectFactory();
        WSA_CONSTANTS = new AddressingConstantsImpl();
    }
}

