/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Mutator;

public class CacheEntryMutator<K, V>
implements Mutator {
    private final Cache<K, V> cache;
    private final CacheInvoker invoker;
    private final K id;
    private final V value;
    private final Set<Flag> flags;
    private final AtomicBoolean mutated = new AtomicBoolean(false);

    public CacheEntryMutator(Cache<K, V> cache, CacheInvoker invoker, K id, V value, Flag ... flags) {
        this.cache = cache;
        this.invoker = invoker;
        this.id = id;
        this.value = value;
        this.flags = EnumSet.of(Flag.IGNORE_RETURN_VALUES, flags);
    }

    public void mutate() {
        if (this.mutated.compareAndSet(false, true)) {
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Mutator.MutateOperation(this.id, this.value), this.flags.toArray(new Flag[this.flags.size()]));
        }
    }
}

