/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.concurrent.Scheduler;
import org.jboss.as.clustering.infinispan.invoker.Evictor;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class SessionEvictionScheduler
implements Scheduler<ImmutableSession> {
    private final Set<String> evictionQueue = new LinkedHashSet<String>();
    final Batcher batcher;
    final Evictor<String> evictor;
    private final ExecutorService executor;
    private final int maxSize;

    public SessionEvictionScheduler(Batcher batcher, Evictor<String> evictor, int maxSize) {
        this(batcher, evictor, maxSize, Executors.newCachedThreadPool(SessionEvictionScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return new JBossThreadFactory(new ThreadGroup(SessionEvictionScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    }

    public SessionEvictionScheduler(Batcher batcher, Evictor<String> evictor, int maxSize, ExecutorService executor) {
        this.batcher = batcher;
        this.evictor = evictor;
        this.maxSize = maxSize;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ImmutableSession session) {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(ImmutableSession session) {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.add(session.getId());
            if (this.evictionQueue.size() > this.maxSize) {
                Iterator<String> sessions = this.evictionQueue.iterator();
                this.executor.submit(new EvictionTask(sessions.next()));
                sessions.remove();
            }
        }
    }

    public void close() {
        this.evictionQueue.clear();
        this.executor.shutdown();
    }

    private class EvictionTask
    implements Runnable {
        private final String id;

        EvictionTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Batch batch = SessionEvictionScheduler.this.batcher.startBatch();
            boolean success = false;
            try {
                InfinispanWebLogger.ROOT_LOGGER.tracef("Passivating session %s", this.id);
                SessionEvictionScheduler.this.evictor.evict((Object)this.id);
                success = true;
            }
            finally {
                if (success) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
        }
    }
}

