/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.InfinispanBatcher;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManager;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactory<A, D>
extends AbstractService<SSOManagerFactory<A, D>>
implements SSOManagerFactory<A, D> {
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});

    public static <A, D> ServiceBuilder<SSOManagerFactory<A, D>> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        InfinispanSSOManagerFactory<A, D> service = new InfinispanSSOManagerFactory<A, D>();
        return target.addService(name, service).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, service.cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, service.affinityFactory);
    }

    private InfinispanSSOManagerFactory() {
    }

    public SSOManagerFactory<A, D> getValue() {
        return this;
    }

    public <L> SSOManager<A, D, L> createSSOManager(IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        Cache authenticationCache = (Cache)this.cache.getValue();
        Cache sessionsCache = (Cache)this.cache.getValue();
        CoarseSSOFactory factory = new CoarseSSOFactory(authenticationCache, sessionsCache, this.invoker, localContextFactory);
        AffinityIdentifierFactory<String> idFactory = new AffinityIdentifierFactory<String>(identifierFactory, authenticationCache, (KeyAffinityServiceFactory)this.affinityFactory.getValue());
        InfinispanBatcher batcher = new InfinispanBatcher(authenticationCache);
        return new InfinispanSSOManager(factory, idFactory, batcher);
    }
}

