/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ContainerEventHandlerService
implements Service<ModClusterService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"modcluster"});
    public static final ServiceName CONFIG_SERVICE_NAME = SERVICE_NAME.append(new String[]{"config"});
    private LoadBalanceFactorProvider load;
    private ModClusterConfig config;
    private final Value<SocketBindingManager> bindingManager;
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private volatile ModClusterService eventHandler;

    ContainerEventHandlerService(ModClusterConfig config, LoadBalanceFactorProvider load, Value<SocketBindingManager> bindingManager) {
        this.config = config;
        this.load = load;
        this.bindingManager = bindingManager;
    }

    public ModClusterService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.eventHandler;
    }

    public void start(StartContext context) {
        SocketBinding binding;
        ModClusterLogger.ROOT_LOGGER.debugf("Starting mod_cluster extension", new Object[0]);
        boolean isMulticast = this.isMulticastEnabled(((SocketBindingManager)this.bindingManager.getValue()).getDefaultInterfaceBinding().getNetworkInterfaces());
        if (this.config.getProxies().isEmpty()) {
            this.config.setAdvertise(Boolean.valueOf(isMulticast));
        }
        if (this.config.getAdvertise().booleanValue() && (binding = (SocketBinding)this.binding.getOptionalValue()) != null) {
            this.config.setAdvertiseSocketAddress(binding.getMulticastSocketAddress());
            this.config.setAdvertiseInterface(binding.getSocketAddress().getAddress());
            if (!isMulticast) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        this.eventHandler = new ModClusterService(this.config, this.load);
    }

    private boolean isMulticastEnabled(Collection<NetworkInterface> ifaces) {
        for (NetworkInterface iface : ifaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException e) {
            }
        }
        return false;
    }

    public void stop(StopContext context) {
        this.eventHandler.shutdown();
        this.eventHandler = null;
    }

    Injector<SocketBinding> getSocketBindingInjector() {
        return this.binding;
    }
}

