/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class AdditionalSetupInterceptor
implements Interceptor {
    private final List<SetupAction> actions;

    public AdditionalSetupInterceptor(List<SetupAction> actions) {
        this.actions = actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            for (SetupAction action : this.actions) {
                action.setup(Collections.emptyMap());
            }
            Object object = context.proceed();
            return object;
        }
        finally {
            ListIterator<SetupAction> iterator = this.actions.listIterator(this.actions.size());
            Throwable error = null;
            while (iterator.hasPrevious()) {
                SetupAction action = iterator.previous();
                try {
                    action.teardown(Collections.emptyMap());
                }
                catch (Throwable e) {
                    error = e;
                }
            }
            if (error != null) {
                throw new RuntimeException(error);
            }
        }
    }

    public static InterceptorFactory factory(List<SetupAction> actions) {
        AdditionalSetupInterceptor interceptor = new AdditionalSetupInterceptor(actions);
        return new ImmediateInterceptorFactory((Interceptor)interceptor);
    }
}

