/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class EEConcurrentDefaultBindingProcessor
implements DeploymentUnitProcessor {
    public static final String COMP_DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:comp/DefaultContextService";
    public static final String MODULE_DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:module/DefaultContextService";
    public static final String COMP_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedExecutorService";
    public static final String MODULE_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:module/DefaultManagedExecutorService";
    public static final String COMP_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedScheduledExecutorService";
    public static final String MODULE_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:module/DefaultManagedScheduledExecutorService";
    public static final String COMP_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";
    public static final String MODULE_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:module/DefaultManagedThreadFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String managedThreadFactory;
        String managedScheduledExecutorService;
        String managedExecutorService;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        String contextService = moduleDescription.getDefaultResourceJndiNames().getContextService();
        if (contextService != null) {
            this.addBinding(contextService, COMP_DEFAULT_CONTEXT_SERVICE_JNDI_NAME, MODULE_DEFAULT_CONTEXT_SERVICE_JNDI_NAME, moduleDescription, deploymentUnit);
        }
        if ((managedExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedExecutorService()) != null) {
            this.addBinding(managedExecutorService, COMP_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME, MODULE_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME, moduleDescription, deploymentUnit);
        }
        if ((managedScheduledExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedScheduledExecutorService()) != null) {
            this.addBinding(managedScheduledExecutorService, COMP_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME, MODULE_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME, moduleDescription, deploymentUnit);
        }
        if ((managedThreadFactory = moduleDescription.getDefaultResourceJndiNames().getManagedThreadFactory()) != null) {
            this.addBinding(managedThreadFactory, COMP_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME, MODULE_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME, moduleDescription, deploymentUnit);
        }
    }

    private void addBinding(String source, String compTarget, String moduleTarget, EEModuleDescription moduleDescription, DeploymentUnit deploymentUnit) {
        LookupInjectionSource injectionSource = new LookupInjectionSource(source);
        if (DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit)) {
            moduleDescription.getBindingConfigurations().add(new BindingConfiguration(moduleTarget, injectionSource));
        } else {
            if (DeploymentTypeMarker.isType(DeploymentType.APPLICATION_CLIENT, deploymentUnit)) {
                moduleDescription.getBindingConfigurations().add(new BindingConfiguration(compTarget, injectionSource));
            }
            for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                if (componentDescription.getNamingMode() != ComponentNamingMode.CREATE) continue;
                componentDescription.getBindingConfigurations().add(new BindingConfiguration(compTarget, injectionSource));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

