/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.w3c.dom.Element;

public class SamlRequestSecurityTokenHandler
extends AbstractPicketLinkTrustHandler {
    private SOAPFactory factory = null;

    protected boolean handleInbound(MessageContext msgContext) {
        String username = this.getUserPrincipalName(msgContext);
        SOAPMessage sm = ((SOAPMessageContext)msgContext).getMessage();
        try {
            SOAPEnvelope envelope = sm.getSOAPPart().getEnvelope();
            SOAPBodyElement rst = (SOAPBodyElement)Util.findElement((Element)envelope, new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestSecurityToken"));
            if (rst != null) {
                rst.addChildElement(this.createUsernameToken(username));
            }
        }
        catch (SOAPException e) {
            logger.jbossWSUnableToCreateBinaryToken((Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("SOAPMessage(SamlRequestSecurityTokenHandler)=" + SOAPUtil.soapMessageAsString((SOAPMessage)sm));
        }
        return true;
    }

    private SOAPElement createUsernameToken(String usernamevalue) throws SOAPException {
        if (this.factory == null) {
            this.factory = SOAPFactory.newInstance();
        }
        SOAPElement usernametoken = this.factory.createElement("UsernameToken", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPElement username = this.factory.createElement("Username", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        username.addTextNode(usernamevalue);
        usernametoken.addChildElement(username);
        return usernametoken;
    }

    private HttpServletRequest getHttpRequest(MessageContext msgContext) {
        HttpServletRequest request = (HttpServletRequest)msgContext.get((Object)"javax.xml.ws.servlet.request");
        if (request == null) {
            try {
                request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            }
            catch (PolicyContextException e) {
                return null;
            }
        }
        return request;
    }

    protected String getUserPrincipalName(MessageContext msgContext) {
        HttpServletRequest servletRequest = this.getHttpRequest(msgContext);
        if (servletRequest == null) {
            logger.warn("Cannot get HttpRequest, ignoring " + SamlRequestSecurityTokenHandler.class.getName());
            return null;
        }
        Principal principal = servletRequest.getUserPrincipal();
        if (principal == null) {
            logger.warn("Cannot get Principal, ignoring " + SamlRequestSecurityTokenHandler.class.getName());
            return null;
        }
        return principal.getName();
    }
}

