/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELManager;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ResourceBundleELResolver;
import javax.el.StaticFieldELResolver;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperMessages;

public final class ELResolverImpl
extends ELResolver {
    public static final boolean NEW_RESOLVER_INSTANCE = Boolean.valueOf(System.getProperty("org.apache.jasper.el.ELResolverImpl.NEW_RESOLVER_INSTANCE", "false"));
    private static final ELResolver DefaultResolver = new CompositeELResolver();
    private final VariableResolver variableResolver;
    private final ExpressionFactory factory;

    public ELResolverImpl(VariableResolver variableResolver, ExpressionFactory factory) {
        this.variableResolver = variableResolver;
        this.factory = factory;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw JasperMessages.MESSAGES.elResolverNullContext();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    return this.variableResolver.resolveVariable(property.toString());
                }
                catch (ELException e) {
                    throw new javax.el.ELException(JasperMessages.MESSAGES.errorResolvingVariable(property.toString(), e.getMessage()), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return ELResolverImpl.getDefaultResolver(this.factory).getValue(context, base, property);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw JasperMessages.MESSAGES.elResolverNullContext();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    Object obj = this.variableResolver.resolveVariable(property.toString());
                    return obj != null ? obj.getClass() : null;
                }
                catch (ELException e) {
                    throw new javax.el.ELException(JasperMessages.MESSAGES.errorResolvingVariable(property.toString(), e.getMessage()), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return ELResolverImpl.getDefaultResolver(this.factory).getType(context, base, property);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, javax.el.ELException {
        if (context == null) {
            throw JasperMessages.MESSAGES.elResolverNullContext();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException(JasperMessages.MESSAGES.legacyVariableResolver());
        }
        if (!context.isPropertyResolved()) {
            ELResolverImpl.getDefaultResolver(this.factory).setValue(context, base, property, value);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw JasperMessages.MESSAGES.elResolverNullContext();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            return true;
        }
        return ELResolverImpl.getDefaultResolver(this.factory).isReadOnly(context, base, property);
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return ELResolverImpl.getDefaultResolver(this.factory).getFeatureDescriptors(context, base);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return ELResolverImpl.getDefaultResolver(this.factory).getCommonPropertyType(context, base);
    }

    public static ELResolver getDefaultResolver(ExpressionFactory factory) {
        if (NEW_RESOLVER_INSTANCE && Constants.IS_SECURITY_ENABLED) {
            CompositeELResolver defaultResolver = new CompositeELResolver();
            defaultResolver.add(factory.getStreamELResolver());
            defaultResolver.add((ELResolver)new StaticFieldELResolver());
            defaultResolver.add((ELResolver)new MapELResolver());
            defaultResolver.add((ELResolver)new ResourceBundleELResolver());
            defaultResolver.add((ELResolver)new ListELResolver());
            defaultResolver.add((ELResolver)new ArrayELResolver());
            defaultResolver.add((ELResolver)new BeanELResolver());
            return defaultResolver;
        }
        return DefaultResolver;
    }

    static {
        ((CompositeELResolver)DefaultResolver).add(ELManager.getExpressionFactory().getStreamELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new StaticFieldELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new MapELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new ResourceBundleELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new ListELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new ArrayELResolver());
        ((CompositeELResolver)DefaultResolver).add((ELResolver)new BeanELResolver());
    }
}

