/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.ManagedSocketFactory;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.NetworkMessages;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.msc.service.ServiceName;

public final class SocketBinding {
    public static final ServiceName JBOSS_BINDING_NAME = ServiceName.JBOSS.append(new String[]{"binding"});
    private final String name;
    private volatile int port;
    private volatile boolean isFixedPort;
    private volatile InetAddress multicastAddress;
    private volatile int multicastPort;
    private volatile List<ClientMapping> clientMappings;
    private final NetworkInterfaceBinding networkInterface;
    private final SocketBindingManager socketBindings;

    public SocketBinding(String name, int port, boolean isFixedPort, InetAddress multicastAddress, int multicastPort, NetworkInterfaceBinding networkInterface, SocketBindingManager socketBindings, List<ClientMapping> clientMappings) {
        this.name = name;
        this.port = port;
        this.isFixedPort = isFixedPort;
        this.multicastAddress = multicastAddress;
        this.multicastPort = multicastPort;
        this.socketBindings = socketBindings;
        this.networkInterface = networkInterface;
        this.clientMappings = clientMappings == null ? Collections.emptyList() : this.fixupMappings(clientMappings);
    }

    private List<ClientMapping> fixupMappings(List<ClientMapping> clientMappings) {
        for (ClientMapping mapping : clientMappings) {
            mapping.updatePortIfUnknown(this.calculatePort());
        }
        return clientMappings;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.networkInterface != null ? this.networkInterface.getAddress() : this.socketBindings.getDefaultInterfaceAddress();
    }

    public NetworkInterfaceBinding getNetworkInterfaceBinding() {
        return this.networkInterface != null ? this.networkInterface : this.socketBindings.getDefaultInterfaceBinding();
    }

    public SocketBindingManager getSocketBindings() {
        return this.socketBindings;
    }

    private int calculatePort() {
        int port = this.port;
        if (!this.isFixedPort) {
            port += this.socketBindings.getPortOffset();
        }
        return port;
    }

    public InetSocketAddress getSocketAddress() {
        int port = this.calculatePort();
        return new InetSocketAddress(this.getAddress(), port);
    }

    public InetSocketAddress getMulticastSocketAddress() {
        if (this.multicastAddress == null) {
            throw NetworkMessages.MESSAGES.noMulticastBinding(this.name);
        }
        return new InetSocketAddress(this.multicastAddress, this.multicastPort);
    }

    public ServerSocket createServerSocket() throws IOException {
        ServerSocket socket = this.getServerSocketFactory().createServerSocket(this.name);
        socket.bind(this.getSocketAddress());
        return socket;
    }

    public ServerSocket createServerSocket(int backlog) throws IOException {
        ServerSocket socket = this.getServerSocketFactory().createServerSocket(this.name);
        socket.bind(this.getSocketAddress(), backlog);
        return socket;
    }

    public DatagramSocket createDatagramSocket() throws SocketException {
        return this.socketBindings.createDatagramSocket(this.name, this.getMulticastSocketAddress());
    }

    public MulticastSocket createMulticastSocket() throws IOException {
        return this.socketBindings.createMulticastSocket(this.name, this.getSocketAddress());
    }

    public ManagedBinding getManagedBinding() {
        SocketBindingManager.NamedManagedBindingRegistry registry = this.socketBindings.getNamedRegistry();
        return registry.getManagedBinding(this.name);
    }

    public boolean isBound() {
        SocketBindingManager.NamedManagedBindingRegistry registry = this.socketBindings.getNamedRegistry();
        return registry.isRegistered(this.name);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.checkNotBound();
        this.port = port;
    }

    public boolean isFixedPort() {
        return this.isFixedPort;
    }

    public void setFixedPort(boolean fixedPort) {
        this.checkNotBound();
        this.isFixedPort = fixedPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int multicastPort) {
        this.checkNotBound();
        this.multicastPort = multicastPort;
    }

    public InetAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(InetAddress multicastAddress) {
        this.checkNotBound();
        this.multicastAddress = multicastAddress;
    }

    public void setClientMappings(List<ClientMapping> clientMappings) {
        this.clientMappings = clientMappings;
    }

    public List<ClientMapping> getClientMappings() {
        return this.clientMappings;
    }

    public int getAbsolutePort() {
        return this.calculatePort();
    }

    void checkNotBound() {
        if (this.isBound()) {
            throw NetworkMessages.MESSAGES.cannotChangeWhileBound();
        }
    }

    ManagedSocketFactory getSocketFactory() {
        return this.socketBindings.getSocketFactory();
    }

    ManagedServerSocketFactory getServerSocketFactory() {
        return this.socketBindings.getServerSocketFactory();
    }
}

