/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.server.Services;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public final class AsynchronousService<T>
implements Service<T> {
    private static final boolean DEFAULT_ASYNC_START = true;
    private static final boolean DEFAULT_ASYNC_STOP = true;
    final Service<T> service;
    private final Value<ExecutorService> executor;
    private final boolean startAsynchronously;
    private final boolean stopAsynchronously;

    public static <T> ServiceBuilder<T> addService(ServiceTarget target, ServiceName name, Service<T> service) {
        return AsynchronousService.addService(target, name, service, true, true);
    }

    public static <T> ServiceBuilder<T> addService(ServiceTarget target, ServiceName name, Service<T> service, boolean startAsynchronously, boolean stopAsynchronously) {
        InjectedValue executor = new InjectedValue();
        ServiceBuilder builder = target.addService(name, new AsynchronousService<T>(service, (Value<ExecutorService>)executor, startAsynchronously, stopAsynchronously));
        Services.addServerExecutorDependency((ServiceBuilder)builder, (Injector)executor, (boolean)false);
        return builder;
    }

    public AsynchronousService(Service<T> service, Value<ExecutorService> executor) {
        this(service, executor, true, true);
    }

    public AsynchronousService(Service<T> service, Value<ExecutorService> executor, boolean startAsynchronously, boolean stopAsynchronously) {
        this.service = service;
        this.executor = executor;
        this.startAsynchronously = startAsynchronously;
        this.stopAsynchronously = stopAsynchronously;
    }

    public T getValue() {
        return (T)this.service.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        if (this.startAsynchronously) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AsynchronousService.this.service.start(context);
                        context.complete();
                    }
                    catch (StartException e) {
                        context.failed(e);
                    }
                    catch (Throwable e) {
                        context.failed(new StartException(e));
                    }
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.start(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        if (this.stopAsynchronously) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AsynchronousService.this.service.stop(context);
                    }
                    finally {
                        context.complete();
                    }
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.stop(context);
        }
    }
}

