/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims.mapper;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.sts.claims.Claim;
import org.apache.cxf.sts.claims.ClaimCollection;

public class ClaimUtils {
    public ClaimCollection add(ClaimCollection collection, Claim ... claims) {
        ClaimCollection resultClaimCollection = null;
        if (collection != null) {
            resultClaimCollection = (ClaimCollection)collection.clone();
            for (Claim c : claims) {
                if (c == null) continue;
                resultClaimCollection.add(c);
            }
        }
        return resultClaimCollection;
    }

    public ClaimCollection add(ClaimCollection collection, ClaimCollection ... claimCollections) {
        ClaimCollection resultClaimCollection = null;
        if (collection != null) {
            resultClaimCollection = (ClaimCollection)collection.clone();
            for (ClaimCollection cc : claimCollections) {
                resultClaimCollection.addAll(cc);
            }
        }
        return resultClaimCollection;
    }

    public Claim create(String claimTypeURI, String ... values) {
        Claim claim = new Claim();
        if (claimTypeURI != null) {
            claim.setClaimType(URI.create(claimTypeURI));
        }
        if (values != null) {
            claim.getValues().addAll(Arrays.asList(values));
        }
        return claim;
    }

    public Claim get(ClaimCollection claims, String claimType) {
        if (claimType == null || claims == null) {
            return null;
        }
        for (Claim c : claims) {
            if (c.getClaimType() == null || !claimType.equals(c.getClaimType().toString())) continue;
            return c;
        }
        return null;
    }

    public ClaimCollection mapType(ClaimCollection claims, Map<String, String> map, boolean keepUnmapped) {
        ClaimCollection mappedClaims = new ClaimCollection();
        if (claims != null && map != null) {
            for (Claim c : claims) {
                String claimType = c.getClaimType() != null ? c.getClaimType().toString() : "";
                String mappedClaimType = map.get(claimType);
                if (mappedClaimType != null) {
                    Claim claim = c.clone();
                    claim.setClaimType(URI.create(mappedClaimType));
                    mappedClaims.add(claim);
                    continue;
                }
                if (!keepUnmapped) continue;
                mappedClaims.add(c.clone());
            }
        }
        return mappedClaims;
    }

    public Claim mapValues(Claim claim, Map<String, String> mapping, boolean keepUnmapped) {
        Claim resultClaim = null;
        if (claim != null) {
            resultClaim = claim.clone();
            List<String> values = resultClaim.getValues();
            ArrayList<String> mappedValues = new ArrayList<String>();
            if (values == null || mapping == null || mapping.size() == 0) {
                resultClaim.setValues(mappedValues);
                return resultClaim;
            }
            for (String value : values) {
                String newValue = mapping.get(value);
                if (newValue != null) {
                    mappedValues.add(newValue);
                    continue;
                }
                if (!keepUnmapped) continue;
                mappedValues.add(value);
            }
            resultClaim.setValues(mappedValues);
        }
        return resultClaim;
    }

    public Claim filterValues(Claim claim, String filter) {
        Claim resultClaim = null;
        if (claim != null) {
            resultClaim = claim.clone();
            List<String> values = resultClaim.getValues();
            ArrayList<String> filteredValues = new ArrayList<String>();
            if (values == null || filter == null) {
                resultClaim.setValues(filteredValues);
                return resultClaim;
            }
            for (String value : values) {
                if (value == null || !value.matches(filter)) continue;
                filteredValues.add(value);
            }
            resultClaim.setValues(filteredValues);
        }
        return resultClaim;
    }

    public Claim merge(ClaimCollection claims, String targetClaimType, String delimiter, String ... claimType) {
        Claim mergedClaim = null;
        StringBuilder sbClaimValue = new StringBuilder();
        for (String sc : claimType) {
            List<String> values;
            Claim c = this.get(claims, sc);
            if (c == null || (values = c.getValues()) == null || values.size() <= 0) continue;
            if (mergedClaim == null) {
                mergedClaim = c.clone();
                sbClaimValue.append(values.get(0));
                mergedClaim.getValues().clear();
                continue;
            }
            sbClaimValue.append(delimiter).append(values.get(0));
        }
        if (mergedClaim != null) {
            mergedClaim.setClaimType(URI.create(targetClaimType));
            mergedClaim.addValue(sbClaimValue.toString());
        }
        return mergedClaim;
    }

    public Claim setType(Claim claim, String claimTypeURI) {
        if (claim != null && claimTypeURI != null) {
            claim.setClaimType(URI.create(claimTypeURI));
        }
        return claim;
    }

    public ClaimCollection updateIssuer(ClaimCollection claims, String newIssuer) {
        ClaimCollection resultClaimCollection = null;
        if (claims != null) {
            resultClaimCollection = new ClaimCollection();
            for (Claim c : claims) {
                Claim newClaim = c.clone();
                if (newClaim.getOriginalIssuer() == null) {
                    newClaim.setOriginalIssuer(newClaim.getIssuer());
                }
                newClaim.setIssuer(newIssuer);
                resultClaimCollection.add(newClaim);
            }
        }
        return resultClaimCollection;
    }

    public Claim upperCaseValues(Claim claim) {
        Claim resultClaim = null;
        if (claim != null && (resultClaim = claim.clone()).getValues() != null) {
            List<String> oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (String value : oldValues) {
                newValues.add(value.toUpperCase());
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public Claim lowerCaseValues(Claim claim) {
        Claim resultClaim = null;
        if (claim != null && (resultClaim = claim.clone()).getValues() != null) {
            List<String> oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (String value : oldValues) {
                newValues.add(value.toLowerCase());
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public Claim wrapValues(Claim claim, String prefix, String suffix) {
        prefix = prefix == null ? "" : prefix;
        suffix = suffix == null ? "" : suffix;
        Claim resultClaim = null;
        if (claim != null && (resultClaim = claim.clone()).getValues() != null) {
            List<String> oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (String value : oldValues) {
                newValues.add(prefix + value + suffix);
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public Claim singleToMultiValue(Claim claim, String delimiter) {
        Claim resultClaim = null;
        if (claim != null && (resultClaim = claim.clone()).getValues() != null) {
            List<String> oldValues = resultClaim.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (String multivalue : oldValues) {
                StringTokenizer st = new StringTokenizer(multivalue, delimiter);
                while (st.hasMoreTokens()) {
                    newValues.add(st.nextToken());
                }
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().addAll(newValues);
        }
        return resultClaim;
    }

    public Claim multiToSingleValue(Claim claim, String delimiter) {
        Claim resultClaim = null;
        if (claim != null && (resultClaim = claim.clone()).getValues() != null) {
            List<String> oldValues = resultClaim.getValues();
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String value : oldValues) {
                if (first) {
                    sb.append((Object)value);
                    first = false;
                    continue;
                }
                sb.append(delimiter).append((Object)value);
            }
            resultClaim.getValues().clear();
            resultClaim.getValues().add(sb.toString());
        }
        return resultClaim;
    }
}

