/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.request.Lifetime;
import org.apache.cxf.sts.request.Participants;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.saml.ext.bean.AudienceRestrictionBean;
import org.apache.ws.security.saml.ext.bean.ConditionsBean;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.joda.time.DateTime;
import org.w3c.dom.Element;

public class DefaultConditionsProvider
implements ConditionsProvider {
    public static final long DEFAULT_MAX_LIFETIME = 43200L;
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultConditionsProvider.class);
    private long lifetime = 1800L;
    private long maxLifetime = 43200L;
    private boolean failLifetimeExceedance = true;
    private boolean acceptClientLifetime;
    private long futureTimeToLive = 60L;

    public long getFutureTimeToLive() {
        return this.futureTimeToLive;
    }

    public void setFutureTimeToLive(long futureTimeToLive) {
        this.futureTimeToLive = futureTimeToLive;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public boolean isAcceptClientLifetime() {
        return this.acceptClientLifetime;
    }

    public void setAcceptClientLifetime(boolean acceptClientLifetime) {
        this.acceptClientLifetime = acceptClientLifetime;
    }

    public boolean isFailLifetimeExceedance() {
        return this.failLifetimeExceedance;
    }

    public void setFailLifetimeExceedance(boolean failLifetimeExceedance) {
        this.failLifetimeExceedance = failLifetimeExceedance;
    }

    @Override
    public ConditionsBean getConditions(TokenProviderParameters providerParameters) {
        List<AudienceRestrictionBean> audienceRestrictions;
        ConditionsBean conditions = this.getConditions(providerParameters.getAppliesToAddress(), providerParameters.getTokenRequirements().getLifetime());
        if (conditions != null && (audienceRestrictions = this.createAudienceRestrictions(providerParameters)) != null && !audienceRestrictions.isEmpty()) {
            if (conditions.getAudienceRestrictions() != null) {
                audienceRestrictions.addAll(conditions.getAudienceRestrictions());
            }
            conditions.setAudienceRestrictions(audienceRestrictions);
        }
        return conditions;
    }

    @Override
    public ConditionsBean getConditions(String appliesToAddress, Lifetime tokenLifetime) {
        ConditionsBean conditions = new ConditionsBean();
        if (this.lifetime > 0L) {
            if (this.acceptClientLifetime && tokenLifetime != null && tokenLifetime.getCreated() != null && tokenLifetime.getExpires() != null) {
                try {
                    XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
                    Date creationTime = fmt.parse(tokenLifetime.getCreated());
                    Date expirationTime = fmt.parse(tokenLifetime.getExpires());
                    if (creationTime == null || expirationTime == null) {
                        LOG.fine("Error in parsing Timestamp Created or Expiration Strings");
                        throw new STSException("Error in parsing Timestamp Created or Expiration Strings", STSException.INVALID_TIME);
                    }
                    Date validCreation = new Date();
                    long currentTime = validCreation.getTime();
                    if (this.futureTimeToLive > 0L) {
                        validCreation.setTime(currentTime + this.futureTimeToLive * 1000L);
                    }
                    if (creationTime.after(validCreation)) {
                        LOG.fine("The Created Time is too far in the future");
                        throw new STSException("The Created Time is too far in the future", STSException.INVALID_TIME);
                    }
                    long requestedLifetime = expirationTime.getTime() - creationTime.getTime();
                    if (requestedLifetime > this.getMaxLifetime() * 1000L) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Requested lifetime [").append(requestedLifetime / 1000L);
                        sb.append(" sec] exceed configured maximum lifetime [").append(this.getMaxLifetime());
                        sb.append(" sec]");
                        LOG.warning(sb.toString());
                        if (this.isFailLifetimeExceedance()) {
                            throw new STSException("Requested lifetime exceeds maximum lifetime", STSException.INVALID_TIME);
                        }
                        expirationTime.setTime(creationTime.getTime() + this.getMaxLifetime() * 1000L);
                    }
                    DateTime creationDateTime = new DateTime(creationTime.getTime());
                    DateTime expirationDateTime = new DateTime(expirationTime.getTime());
                    conditions.setNotAfter(expirationDateTime);
                    conditions.setNotBefore(creationDateTime);
                }
                catch (ParseException e) {
                    LOG.warning("Failed to parse life time element: " + e.getMessage());
                    conditions.setTokenPeriodMinutes((int)(this.lifetime / 60L));
                }
            } else {
                conditions.setTokenPeriodMinutes((int)(this.lifetime / 60L));
            }
        } else {
            conditions.setTokenPeriodMinutes(5);
        }
        if (appliesToAddress != null) {
            AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
            audienceRestriction.setAudienceURIs(Collections.singletonList(appliesToAddress));
            conditions.setAudienceRestrictions(Collections.singletonList(audienceRestriction));
        }
        return conditions;
    }

    protected List<AudienceRestrictionBean> createAudienceRestrictions(TokenProviderParameters providerParameters) {
        ArrayList<AudienceRestrictionBean> audienceRestrictions = new ArrayList<AudienceRestrictionBean>();
        Participants participants = providerParameters.getTokenRequirements().getParticipants();
        if (participants != null) {
            String address = this.extractAddressFromParticipantsEPR(participants.getPrimaryParticipant());
            if (address != null) {
                AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
                audienceRestriction.setAudienceURIs(Collections.singletonList(address));
                audienceRestrictions.add(audienceRestriction);
            }
            if (participants.getParticipants() != null) {
                for (Object participant : participants.getParticipants()) {
                    if (participant == null || (address = this.extractAddressFromParticipantsEPR(participant)) == null) continue;
                    AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
                    audienceRestriction.setAudienceURIs(Collections.singletonList(address));
                    audienceRestrictions.add(audienceRestriction);
                }
            }
        }
        return audienceRestrictions;
    }

    protected String extractAddressFromParticipantsEPR(Object participants) {
        if (participants instanceof Element) {
            String localName = ((Element)participants).getLocalName();
            String namespace = ((Element)participants).getNamespaceURI();
            if ("http://www.w3.org/2005/08/addressing".equals(namespace) && "EndpointReference".equals(localName)) {
                LOG.fine("Found EndpointReference element");
                Element address = DOMUtils.getFirstChildWithName((Element)((Element)participants), (String)"http://www.w3.org/2005/08/addressing", (String)"Address");
                if (address != null) {
                    LOG.fine("Found address element");
                    return address.getTextContent();
                }
            } else if (("http://www.w3.org/ns/ws-policy".equals(namespace) || "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(namespace)) && "URI".equals(localName)) {
                return ((Element)participants).getTextContent();
            }
            LOG.fine("Participants element does not exist or could not be parsed");
            return null;
        }
        if (participants instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)participants;
            QName participantsName = jaxbElement.getName();
            if ("http://www.w3.org/2005/08/addressing".equals(participantsName.getNamespaceURI()) && "EndpointReference".equals(participantsName.getLocalPart())) {
                LOG.fine("Found EndpointReference element");
                EndpointReferenceType endpointReference = (EndpointReferenceType)jaxbElement.getValue();
                if (endpointReference.getAddress() != null) {
                    LOG.fine("Found address element");
                    return endpointReference.getAddress().getValue();
                }
            }
            LOG.fine("Participants element does not exist or could not be parsed");
        }
        return null;
    }
}

