/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.picketlink.identity.federation.core.sts.registry.AbstractJDBCRegistry;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

public class OJDBCTokenRegistry
extends AbstractJDBCRegistry
implements SecurityTokenRegistry {
    private static final String INSERT_SQL = "INSERT INTO STS_TOKEN_REGISTRY (TOKEN_ID, TOKEN, CREATED_DATE) VALUES (?,?,?)";
    private static final String DELETE_SQL = "DELETE FROM STS_TOKEN_REGISTRY WHERE TOKEN_ID = ?";
    private static final String SELECT_SQL = "SELECT TOKEN FROM STS_TOKEN_REGISTRY WHERE TOKEN_ID = ?";

    public OJDBCTokenRegistry() {
        super("jdbc/picketlink-sts");
    }

    public OJDBCTokenRegistry(String jndiName) {
        super(jndiName);
    }

    public OJDBCTokenRegistry(String initial, String jndiName) {
        super(initial, jndiName);
    }

    @Override
    public void addToken(String tokenID, Object token) throws IOException {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            byte[] marshalledToken = this.marshallToken(token);
            conn = this.dataSource.getConnection();
            Date tokenCreationDate = Calendar.getInstance().getTime();
            preparedStatement = conn.prepareStatement(INSERT_SQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setBytes(2, marshalledToken);
            preparedStatement.setTimestamp(3, new Timestamp(tokenCreationDate.getTime()), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }

    @Override
    public void removeToken(String tokenID) throws IOException {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(DELETE_SQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }

    @Override
    public Object getToken(String tokenID) {
        try {
            return this.unmarshalToken(this.getLOB(tokenID));
        }
        catch (IOException e) {
            throw logger.runtimeException("getToken", (Throwable)e);
        }
    }

    private byte[] marshallToken(Object token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(token);
        return baos.toByteArray();
    }

    private Object unmarshalToken(byte[] serialized) {
        try {
            ByteArrayInputStream byteArray = new ByteArrayInputStream(serialized);
            return new ObjectInputStream(byteArray).readObject();
        }
        catch (Exception e) {
            throw logger.errorUnmarshallingToken((Throwable)e);
        }
    }

    private byte[] getLOB(String tokenID) throws IOException {
        byte[] byArray;
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(SELECT_SQL);
            preparedStatement.setString(1, tokenID);
            resultSet = preparedStatement.executeQuery();
            byArray = resultSet.getBytes(1);
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(conn);
        return byArray;
    }
}

