/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Flow;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Split;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.FlowExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.SplitContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;

public final class SplitExecutionRunner
extends CompositeExecutionRunner<SplitContextImpl>
implements Runnable {
    private final Split split;

    public SplitExecutionRunner(SplitContextImpl splitContext, CompositeExecutionRunner enclosingRunner) {
        super(splitContext, enclosingRunner);
        this.split = splitContext.getSplit();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.split.getFlows();
    }

    @Override
    public void run() {
        String next;
        boolean terminateSplit;
        block16: {
            ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
            List<Flow> flows = this.split.getFlows();
            CountDownLatch latch = new CountDownLatch(flows.size());
            terminateSplit = false;
            try {
                for (Flow f : flows) {
                    this.runFlow(f, latch);
                }
                latch.await();
                List<FlowExecutionImpl> fes = ((SplitContextImpl)this.batchContext).getFlowExecutions();
                AbstractExecution failedFlow = null;
                AbstractExecution stoppedFlow = null;
                AbstractExecution endedFlow = null;
                for (int i = 0; i < fes.size(); ++i) {
                    FlowExecutionImpl flowExecution = fes.get(i);
                    if (flowExecution.getBatchStatus() == BatchStatus.FAILED) {
                        failedFlow = flowExecution;
                        break;
                    }
                    if (flowExecution.getBatchStatus() == BatchStatus.STOPPED) {
                        stoppedFlow = flowExecution;
                        continue;
                    }
                    if (flowExecution.getBatchStatus() != BatchStatus.COMPLETED || !flowExecution.isEnded()) continue;
                    endedFlow = flowExecution;
                }
                if (failedFlow != null || stoppedFlow != null || endedFlow != null) {
                    String splitExitStatus;
                    BatchStatus splitBatchStatus;
                    terminateSplit = true;
                    if (failedFlow != null) {
                        splitBatchStatus = failedFlow.getBatchStatus();
                        splitExitStatus = failedFlow.getExitStatus();
                    } else if (stoppedFlow != null) {
                        splitBatchStatus = stoppedFlow.getBatchStatus();
                        splitExitStatus = stoppedFlow.getExitStatus();
                    } else {
                        splitBatchStatus = endedFlow.getBatchStatus();
                        splitExitStatus = endedFlow.getExitStatus();
                    }
                    ((SplitContextImpl)this.batchContext).setBatchStatus(splitBatchStatus);
                    if (splitExitStatus != null) {
                        ((SplitContextImpl)this.batchContext).setExitStatus(splitExitStatus);
                    }
                    for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                        c.setBatchStatus(splitBatchStatus);
                        if (splitExitStatus == null) continue;
                        c.setExitStatus(splitExitStatus);
                    }
                    break block16;
                }
                if (!((SplitContextImpl)this.batchContext).getBatchStatus().equals((Object)BatchStatus.STARTED)) break block16;
                ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
            }
            catch (Throwable e) {
                terminateSplit = true;
                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.split.getId(), this.split);
                for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                    c.setBatchStatus(BatchStatus.FAILED);
                }
            }
        }
        if (!terminateSplit && ((SplitContextImpl)this.batchContext).getBatchStatus() == BatchStatus.COMPLETED && (next = this.split.getAttributeNext()) != null) {
            List<FlowExecutionImpl> fes = ((SplitContextImpl)this.batchContext).getFlowExecutions();
            StepExecution[] stepExecutions = new StepExecution[fes.size()];
            for (int i = 0; i < fes.size(); ++i) {
                stepExecutions[i] = fes.get(i).getLastStepExecution();
            }
            this.enclosingRunner.runJobElement(next, stepExecutions);
        }
    }
}

