/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common.v11;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.v11.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefPool;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefXaPool;
import org.jboss.jca.common.api.metadata.common.v11.WorkManager;
import org.jboss.jca.common.api.metadata.common.v11.WorkManagerSecurity;
import org.jboss.jca.common.api.metadata.ironjacamar.v11.IronJacamar;
import org.jboss.jca.common.api.metadata.resourceadapter.v11.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.v11.CommonConnDefImpl;
import org.jboss.jca.common.metadata.common.v11.ConnDefPoolImpl;
import org.jboss.jca.common.metadata.common.v11.ConnDefXaPoolImpl;
import org.jboss.jca.common.metadata.common.v11.WorkManagerImpl;
import org.jboss.jca.common.metadata.common.v11.WorkManagerSecurityImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends org.jboss.jca.common.metadata.common.v10.CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected CommonConnDef parseConnectionDefinitions(XMLStreamReader reader, Boolean isXA) throws XMLStreamException, ParserException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        CommonSecurity security = null;
        CommonTimeOut timeOut = null;
        CommonValidation validation = null;
        ConnDefXaPool pool = null;
        Recovery recovery = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String poolName = null;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean sharable = Defaults.SHARABLE;
        Boolean enlistment = Defaults.ENLISTMENT;
        int attributeSize = reader.getAttributeCount();
        if (isXA == null) {
            isXA = Boolean.FALSE;
        }
        block23: for (int i = 0; i < attributeSize; ++i) {
            CommonConnDef.Attribute attribute = CommonConnDef.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block23;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case SHARABLE: {
                    sharable = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                case ENLISTMENT: {
                    enlistment = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block23;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) == ResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        return new CommonConnDefImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, sharable, enlistment, (CommonPool)pool, timeOut, validation, security, recovery, isXA);
                    }
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) != CommonConnDef.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonConnDef.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperty(configProperties, reader);
                            break block10;
                        }
                        case SECURITY: {
                            security = this.parseSecuritySettings(reader);
                            break block10;
                        }
                        case TIMEOUT: {
                            timeOut = this.parseTimeOut(reader, isXA);
                            break block10;
                        }
                        case VALIDATION: {
                            validation = this.parseValidation(reader);
                            break block10;
                        }
                        case XA_POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXA = Boolean.TRUE;
                            break block10;
                        }
                        case POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block10;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManager parseWorkManager(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        WorkManagerSecurity security = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (IronJacamar.Tag.forName((String)reader.getLocalName()) == IronJacamar.Tag.WORKMANAGER) {
                        return new WorkManagerImpl(security);
                    }
                    if (IronJacamar.Tag.forName((String)reader.getLocalName()) != IronJacamar.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManager.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY: {
                            security = this.parseWorkManagerSecurity(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManagerSecurity parseWorkManagerSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean mappingRequired = false;
        String domain = null;
        String defaultPrincipal = null;
        ArrayList<String> defaultGroups = null;
        HashMap<String, String> userMappings = null;
        HashMap<String, String> groupMappings = null;
        boolean userMappingEnabled = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (WorkManager.Tag.forName((String)reader.getLocalName()) == WorkManager.Tag.SECURITY) {
                        return new WorkManagerSecurityImpl(mappingRequired, domain, defaultPrincipal, defaultGroups, userMappings, groupMappings);
                    }
                    if (WorkManagerSecurity.Tag.forName((String)reader.getLocalName()) != WorkManagerSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManagerSecurity.Tag.forName((String)reader.getLocalName())) {
                        case DEFAULT_GROUPS: 
                        case MAPPINGS: {
                            break block0;
                        }
                        case MAPPING_REQUIRED: {
                            mappingRequired = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case DOMAIN: {
                            domain = this.elementAsString(reader);
                            break block0;
                        }
                        case DEFAULT_PRINCIPAL: {
                            defaultPrincipal = this.elementAsString(reader);
                            break block0;
                        }
                        case GROUP: {
                            if (defaultGroups == null) {
                                defaultGroups = new ArrayList<String>(1);
                            }
                            defaultGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case USERS: {
                            userMappingEnabled = true;
                            break block0;
                        }
                        case GROUPS: {
                            userMappingEnabled = false;
                            break block0;
                        }
                        case MAP: {
                            String to;
                            String from;
                            if (userMappingEnabled) {
                                if (userMappings == null) {
                                    userMappings = new HashMap<String, String>();
                                }
                                if ((from = this.attributeAsString(reader, WorkManagerSecurity.Attribute.FROM.getLocalName())) == null || from.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                                }
                                to = this.attributeAsString(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                                if (to == null || to.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                                }
                                userMappings.put(from, to);
                                break block0;
                            }
                            if (groupMappings == null) {
                                groupMappings = new HashMap<String, String>();
                            }
                            if ((from = this.attributeAsString(reader, WorkManagerSecurity.Attribute.FROM.getLocalName())) == null || from.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                            }
                            to = this.attributeAsString(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                            if (to == null || to.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                            }
                            groupMappings.put(from, to);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected ConnDefPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.POOL) {
                        return new ConnDefPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, capacity);
                    }
                    if (ConnDefPool.Tag.forName((String)reader.getLocalName()) != ConnDefPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ConnDefPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            initialPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case CAPACITY: {
                            capacity = this.parseCapacity(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected ConnDefXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        Boolean interleaving = Defaults.INTERLEAVING;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (CommonConnDef.Tag.forName((String)reader.getLocalName()) == CommonConnDef.Tag.XA_POOL) {
                        return new ConnDefXaPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, capacity, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
                    }
                    if (ConnDefXaPool.Tag.forName((String)reader.getLocalName()) != ConnDefXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ConnDefXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            initialPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            isSameRmOverride = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case CAPACITY: {
                            capacity = this.parseCapacity(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

