/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.Connector10;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public abstract class ConnectorAbstractmpl
implements Connector {
    private static final long serialVersionUID = -2054156739973617322L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final XsdString vendorName;
    protected final XsdString eisType;
    protected final LicenseType license;
    protected final ResourceAdapter resourceadapter;
    protected final String id;
    protected final ArrayList<LocalizedXsdString> description;
    protected final ArrayList<LocalizedXsdString> displayName;
    protected final ArrayList<Icon> icon;

    protected ConnectorAbstractmpl(XsdString vendorName, XsdString eisType, LicenseType license, ResourceAdapter resourceadapter, List<LocalizedXsdString> description, List<LocalizedXsdString> displayName, List<Icon> icon, String id) {
        this.vendorName = vendorName;
        if (!XsdString.isNull((XsdString)this.vendorName)) {
            this.vendorName.setTag(Connector10.Tag.VENDOR_NAME.toString());
        }
        this.eisType = eisType;
        if (!XsdString.isNull((XsdString)this.eisType)) {
            this.eisType.setTag(Connector10.Tag.EIS_TYPE.toString());
        }
        this.license = license;
        this.resourceadapter = resourceadapter;
        this.id = id;
        if (description != null) {
            this.description = new ArrayList(description.size());
            this.description.addAll(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(Connector10.Tag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList(0);
        }
        if (displayName != null) {
            this.displayName = new ArrayList(displayName.size());
            this.displayName.addAll(displayName);
            for (LocalizedXsdString d : this.displayName) {
                d.setTag(Connector10.Tag.DISPLAY_NAME.toString());
            }
        } else {
            this.displayName = new ArrayList(0);
        }
        if (icon != null) {
            this.icon = new ArrayList(icon.size());
            this.icon.addAll(icon);
        } else {
            this.icon = new ArrayList(0);
        }
    }

    public XsdString getVendorName() {
        return this.vendorName;
    }

    public XsdString getEisType() {
        return this.eisType;
    }

    public LicenseType getLicense() {
        return this.license;
    }

    public ResourceAdapter getResourceadapter() {
        return this.resourceadapter;
    }

    public List<LocalizedXsdString> getDescriptions() {
        return this.description == null ? null : Collections.unmodifiableList(this.description);
    }

    public List<LocalizedXsdString> getDisplayNames() {
        return this.displayName == null ? null : Collections.unmodifiableList(this.displayName);
    }

    public List<Icon> getIcons() {
        return this.icon == null ? null : Collections.unmodifiableList(this.icon);
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eisType == null ? 0 : this.eisType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.resourceadapter == null ? 0 : this.resourceadapter.hashCode());
        result = 31 * result + (this.vendorName == null ? 0 : this.vendorName.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorAbstractmpl)) {
            return false;
        }
        ConnectorAbstractmpl other = (ConnectorAbstractmpl)obj;
        if (this.eisType == null ? other.eisType != null : !this.eisType.equals((Object)other.eisType)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals((Object)other.license)) {
            return false;
        }
        if (this.resourceadapter == null ? other.resourceadapter != null : !this.resourceadapter.equals(other.resourceadapter)) {
            return false;
        }
        if (this.vendorName == null ? other.vendorName != null : !this.vendorName.equals((Object)other.vendorName)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
    }

    public void validate() throws ValidateException {
        ResourceAdapter ra = this.getResourceadapter();
        if (ra == null) {
            throw new ValidateException(bundle.noMetadataForResourceAdapter());
        }
        ra.validate();
    }

    public Connector merge(MergeableMetadata<?> inputMd) throws Exception {
        return this;
    }

    public abstract CopyableMetaData copy();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LocalizedXsdString d : this.description) {
            sb.append(d);
        }
        for (LocalizedXsdString n : this.displayName) {
            sb.append(n);
        }
        for (Icon i : this.icon) {
            sb.append(i);
        }
        if (!XsdString.isNull((XsdString)this.vendorName)) {
            sb.append(this.vendorName);
        }
        if (!XsdString.isNull((XsdString)this.eisType)) {
            sb.append(this.eisType);
        }
        if (this.license != null) {
            sb.append(this.license);
        }
        return sb.toString();
    }
}

