/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.LogFactory;

public class HotRodTargetMigrator
implements TargetMigrator {
    private static final String MIGRATION_MANAGER_HOT_ROD_KNOWN_KEYS = "___MigrationManager_HotRod_KnownKeys___";
    private static final Log log = (Log)LogFactory.getLog(HotRodTargetMigrator.class, Log.class);

    public String getName() {
        return "hotrod";
    }

    public long synchronizeData(final Cache<Object, Object> cache) throws CacheException {
        byte[] knownKeys;
        int threads = Runtime.getRuntime().availableProcessors();
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        Set stores = loaderManager.getStores(RemoteStore.class);
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        try {
            knownKeys = marshaller.objectToByteBuffer((Object)MIGRATION_MANAGER_HOT_ROD_KNOWN_KEYS);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        for (RemoteStore store : stores) {
            Set keys;
            RemoteCache<Object, Object> storeCache = store.getRemoteCache();
            if (!storeCache.containsKey((Object)knownKeys)) continue;
            RemoteStoreConfiguration storeConfig = store.getConfiguration();
            if (!storeConfig.hotRodWrapping()) {
                throw log.remoteStoreNoHotRodWrapping(cache.getName());
            }
            try {
                keys = (Set)marshaller.objectFromByteBuffer((byte[])storeCache.get((Object)knownKeys));
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            ExecutorService es = Executors.newFixedThreadPool(threads);
            final AtomicInteger count = new AtomicInteger(0);
            for (Object okey : keys) {
                final byte[] key = okey instanceof ByteArrayKey ? ((ByteArrayKey)okey).getData() : (byte[])okey;
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cache.get((Object)key);
                            int i = count.getAndIncrement();
                            if (log.isDebugEnabled() && i % 100 == 0) {
                                log.debugf(">>    Moved %s keys\n", i);
                            }
                        }
                        catch (Exception e) {
                            log.keyMigrationFailed(Util.toStr((Object)key), e);
                        }
                    }
                });
            }
            es.shutdown();
            try {
                while (!es.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            return count.longValue();
        }
        throw log.missingMigrationData(cache.getName());
    }

    public void disconnectSource(Cache<Object, Object> cache) throws CacheException {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        loaderManager.disableStore(RemoteStore.class.getName());
    }
}

