/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.util.AbstractMap;
import java.util.Map;
import org.jboss.as.web.session.RoutingSupport;

public class SimpleRoutingSupport
implements RoutingSupport {
    public static final String DEFAULT_DELIMITER = ".";
    private final String delimiter;

    public SimpleRoutingSupport() {
        this(DEFAULT_DELIMITER);
    }

    public SimpleRoutingSupport(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public Map.Entry<String, String> parse(String id) {
        int index = id != null ? id.indexOf(this.delimiter) : -1;
        return index < 0 ? new AbstractMap.SimpleImmutableEntry<String, Object>(id, null) : new AbstractMap.SimpleImmutableEntry<String, String>(id.substring(0, index), id.substring(index + this.delimiter.length()));
    }

    @Override
    public String format(String sessionId, String routeId) {
        return routeId != null && !routeId.isEmpty() ? String.format("%s%s%s", sessionId, this.delimiter, routeId) : sessionId;
    }
}

