/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import com.sun.faces.spi.InjectionProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FlashFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

final class FactoryFinderInstance {
    private final Map<String, Object> factories;
    private final Map<String, List<String>> savedFactoryNames;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private static final String INJECTION_PROVIDER_KEY = FactoryFinder.class.getPackage().getName() + "INJECTION_PROVIDER_KEY";
    private static final String[] FACTORY_NAMES;
    private static final Map<String, Class> FACTORY_CLASSES;
    private static final Logger LOGGER;

    public FactoryFinderInstance() {
        this.factories = new HashMap<String, Object>();
        this.savedFactoryNames = new HashMap<String, List<String>>();
        for (String name : FACTORY_NAMES) {
            this.factories.put(name, new ArrayList(4));
        }
        this.copyInjectionProviderFromFacesContext();
    }

    public FactoryFinderInstance(FactoryFinderInstance toCopy) {
        this.factories = new HashMap<String, Object>();
        this.savedFactoryNames = new HashMap<String, List<String>>();
        this.factories.putAll(toCopy.savedFactoryNames);
        this.copyInjectionProviderFromFacesContext();
    }

    private void copyInjectionProviderFromFacesContext() {
        InjectionProvider injectionProvider = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context) {
            injectionProvider = (InjectionProvider)context.getAttributes().get("com.sun.faces.config.ConfigManager_INJECTION_PROVIDER_TASK");
        }
        if (null != injectionProvider) {
            this.factories.put(INJECTION_PROVIDER_KEY, injectionProvider);
        } else if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unable to obtain InjectionProvider from init time FacesContext. Does this container implement the Mojarra Injection SPI?");
        }
    }

    private Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        List<String> fromServices;
        String curImplClass;
        int len;
        Object result = null;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if ((fromServices = this.getImplNameFromServices(classLoader, factoryName)) != null) {
            for (String name : fromServices) {
                result = this.getImplGivenPreviousImpl(classLoader, factoryName, name, result);
            }
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> result;
        block12: {
            result = null;
            String resourceName = "META-INF/services/" + factoryName;
            BufferedReader reader = null;
            try {
                Enumeration<URL> e = classLoader.getResources(resourceName);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream stream = conn.getInputStream();
                    if (stream == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        if (result == null) {
                            result = new ArrayList<String>(3);
                        }
                        result.add(reader.readLine());
                    }
                    catch (UnsupportedEncodingException uee) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                            reader = null;
                        }
                        if (stream == null) continue;
                        stream.close();
                        stream = null;
                    }
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    private Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz;
        Class factoryClass = null;
        Object[] newInstanceArgs = new Object[1];
        Object result = null;
        InjectionProvider provider = null;
        if (null != previousImpl && null != (factoryClass = this.getFactoryClass(factoryName))) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                Class[] getCtorArg = new Class[]{factoryClass};
                Constructor<?> ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
                provider = this.getInjectionProvider();
                if (null != provider) {
                    provider.inject(result);
                    provider.invokePostConstruct(result);
                } else if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to inject {0} because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?", (Object)result);
                }
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        return result;
    }

    private Class getFactoryClass(String factoryClassName) {
        return FACTORY_CLASSES.get(factoryClassName);
    }

    public Collection<Object> getFactories() {
        return this.factories.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFactory(String factoryName, String implementation) {
        this.validateFactoryName(factoryName);
        Object result = this.factories.get(factoryName);
        this.lock.writeLock().lock();
        try {
            if (result instanceof List) {
                TypedCollections.dynamicallyCastList((List)result, String.class).add(0, implementation);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    InjectionProvider getInjectionProvider() {
        InjectionProvider result = (InjectionProvider)this.factories.get(INJECTION_PROVIDER_KEY);
        return result;
    }

    void clearInjectionProvider() {
        this.factories.remove(INJECTION_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFactory(String factoryName) {
        Object factoryOrList;
        this.validateFactoryName(factoryName);
        this.lock.readLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
            this.savedFactoryNames.put(factoryName, new ArrayList((List)factoryOrList));
            ClassLoader cl = this.getClassLoader();
            Object factory = this.getImplementationInstance(cl, factoryName, (List)factoryOrList);
            if (factory == null) {
                ResourceBundle rb = LOGGER.getResourceBundle();
                String message = rb.getString("severe.no_factory");
                message = MessageFormat.format(message, factoryName);
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, message);
                }
                if (null == (factory = FactoryFinder.FACTORIES_CACHE.getFallbackFactory(this, factoryName))) {
                    message = rb.getString("severe.no_factory_backup_failed");
                    message = MessageFormat.format(message, factoryName);
                    throw new IllegalStateException(message);
                }
            }
            this.factories.put(factoryName, factory);
            Object object = factory;
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    static {
        HashMap<String, Class> buildUpFactoryClasses = new HashMap<String, Class>();
        buildUpFactoryClasses.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
        buildUpFactoryClasses.put("javax.faces.component.visit.VisitContextFactory", VisitContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.ExceptionHandlerFactory", ExceptionHandlerFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.ExternalContextFactory", ExternalContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.FlashFactory", FlashFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.PartialViewContextFactory", PartialViewContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
        buildUpFactoryClasses.put("javax.faces.lifecycle.ClientWindowFactory", ClientWindowFactory.class);
        buildUpFactoryClasses.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.ViewDeclarationLanguageFactory", ViewDeclarationLanguageFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.facelets.FaceletCacheFactory", FaceletCacheFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.facelets.TagHandlerDelegateFactory", TagHandlerDelegateFactory.class);
        buildUpFactoryClasses.put("javax.faces.flow.FlowHandlerFactory", FlowHandlerFactory.class);
        FACTORY_CLASSES = Collections.unmodifiableMap(buildUpFactoryClasses);
        FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.FlashFactory", "javax.faces.flow.FlowHandlerFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
        Arrays.sort(FACTORY_NAMES);
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }
}

