/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.singleton.SingletonServiceBuilderFactoryService;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;

public class SingletonServiceBuilderFactoryProvider
implements CacheServiceProvider {
    private static ServiceName getServiceName(String containerName, String cacheName) {
        return SingletonServiceBuilderFactory.SERVICE_NAME.append(new String[]{containerName, cacheName});
    }

    public Collection<ServiceName> getServiceNames(String containerName, String cacheName, boolean defaultCache) {
        return Collections.singleton(SingletonServiceBuilderFactoryProvider.getServiceName(containerName, cacheName));
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId) {
        ServiceBuilder builder = target.addService(SingletonServiceBuilderFactoryProvider.getServiceName(containerName, cacheName), (Service)new SingletonServiceBuilderFactoryService(containerName, cacheName)).setInitialMode(ServiceController.Mode.ACTIVE);
        if (defaultCache) {
            builder.addAliases(new ServiceName[]{SingletonServiceBuilderFactoryProvider.getServiceName(containerName, "default")});
        }
        return Collections.singleton(builder.install());
    }
}

