/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class ThreadLocalSSLSocketFactory
extends SSLSocketFactory {
    private static final ThreadLocal<SSLSocketFactory> socketFactory = new ThreadLocal();
    private final SSLSocketFactory delegate;

    public ThreadLocalSSLSocketFactory() {
        SSLSocketFactory socketFactory = ThreadLocalSSLSocketFactory.socketFactory.get();
        if (socketFactory == null) {
            socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        this.delegate = socketFactory;
    }

    static void setSSLSocketFactory(SSLSocketFactory factory) {
        socketFactory.set(factory);
    }

    static void removeSSLSocketFactory() {
        socketFactory.remove();
    }

    public static SocketFactory getDefault() {
        return new ThreadLocalSSLSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.delegate.createSocket(socket, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.delegate.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.delegate.createSocket(address, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.delegate.createSocket(host, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.delegate.createSocket(address, port, localAddress, localPort);
    }
}

