/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.naming.jndi;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.jboss.as.jacorb.JacORBMessages;
import org.omg.CosNaming.NameComponent;

public final class CNNameParser
implements NameParser {
    private static final Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';
    private static final char escapeChar = '\\';

    @Override
    public Name parse(String name) throws NamingException {
        Vector comps = CNNameParser.insStringToStringifiedComps(name);
        return new CNCompoundName(comps.elements());
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int len = name.size();
        if (len == 0) {
            return new NameComponent[0];
        }
        NameComponent[] answer = new NameComponent[len];
        for (int i = 0; i < len; ++i) {
            answer[i] = CNNameParser.parseComponent(name.get(i));
        }
        return answer;
    }

    static String cosNameToInsString(NameComponent[] cname) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < cname.length; ++i) {
            if (i > 0) {
                str.append('/');
            }
            str.append(CNNameParser.stringifyComponent(cname[i]));
        }
        return str.toString();
    }

    static Name cosNameToName(NameComponent[] cname) {
        CompositeName nm = new CompositeName();
        for (int i = 0; cname != null && i < cname.length; ++i) {
            try {
                nm.add(CNNameParser.stringifyComponent(cname[i]));
                continue;
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        return nm;
    }

    private static Vector insStringToStringifiedComps(String str) throws InvalidNameException {
        int len = str.length();
        Vector<String> components = new Vector<String>(10);
        char[] id = new char[len];
        char[] kind = new char[len];
        int i = 0;
        while (i < len) {
            int kindCount = 0;
            int idCount = 0;
            boolean idMode = true;
            while (i < len && str.charAt(i) != '/') {
                if (str.charAt(i) == '\\') {
                    if (i + 1 >= len) {
                        throw JacORBMessages.MESSAGES.unescapedCharacter(str);
                    }
                    if (CNNameParser.isMeta(str.charAt(i + 1))) {
                        ++i;
                        if (idMode) {
                            id[idCount++] = str.charAt(i++);
                            continue;
                        }
                        kind[kindCount++] = str.charAt(i++);
                        continue;
                    }
                    throw JacORBMessages.MESSAGES.invalidEscapedCharacter(str);
                }
                if (idMode && str.charAt(i) == '.') {
                    ++i;
                    idMode = false;
                    continue;
                }
                if (idMode) {
                    id[idCount++] = str.charAt(i++);
                    continue;
                }
                kind[kindCount++] = str.charAt(i++);
            }
            components.addElement(CNNameParser.stringifyComponent(new NameComponent(new String(id, 0, idCount), new String(kind, 0, kindCount))));
            if (i >= len) continue;
            ++i;
        }
        return components;
    }

    private static NameComponent parseComponent(String compStr) throws InvalidNameException {
        int i;
        NameComponent comp = new NameComponent();
        int kindSep = -1;
        int len = compStr.length();
        int j = 0;
        char[] newStr = new char[len];
        boolean escaped = false;
        for (i = 0; i < len && kindSep < 0; ++i) {
            if (escaped) {
                newStr[j++] = compStr.charAt(i);
                escaped = false;
                continue;
            }
            if (compStr.charAt(i) == '\\') {
                if (i + 1 >= len) {
                    throw JacORBMessages.MESSAGES.unescapedCharacter(compStr);
                }
                if (CNNameParser.isMeta(compStr.charAt(i + 1))) {
                    escaped = true;
                    continue;
                }
                throw JacORBMessages.MESSAGES.invalidEscapedCharacter(compStr);
            }
            if (compStr.charAt(i) == '.') {
                kindSep = i;
                continue;
            }
            newStr[j++] = compStr.charAt(i);
        }
        comp.id = new String(newStr, 0, j);
        if (kindSep < 0) {
            comp.kind = "";
        } else {
            j = 0;
            escaped = false;
            for (i = kindSep + 1; i < len; ++i) {
                if (escaped) {
                    newStr[j++] = compStr.charAt(i);
                    escaped = false;
                    continue;
                }
                if (compStr.charAt(i) == '\\') {
                    if (i + 1 >= len) {
                        throw JacORBMessages.MESSAGES.unescapedCharacter(compStr);
                    }
                    if (CNNameParser.isMeta(compStr.charAt(i + 1))) {
                        escaped = true;
                        continue;
                    }
                    throw JacORBMessages.MESSAGES.invalidEscapedCharacter(compStr);
                }
                newStr[j++] = compStr.charAt(i);
            }
            comp.kind = new String(newStr, 0, j);
        }
        return comp;
    }

    private static String stringifyComponent(NameComponent comp) {
        StringBuffer one = new StringBuffer(CNNameParser.escape(comp.id));
        if (comp.kind != null && !comp.kind.equals("")) {
            one.append('.' + CNNameParser.escape(comp.kind));
        }
        if (one.length() == 0) {
            return ".";
        }
        return one.toString();
    }

    private static String escape(String str) {
        if (str.indexOf(46) < 0 && str.indexOf(47) < 0 && str.indexOf(92) < 0) {
            return str;
        }
        int len = str.length();
        int j = 0;
        char[] newStr = new char[len + len];
        for (int i = 0; i < len; ++i) {
            if (CNNameParser.isMeta(str.charAt(i))) {
                newStr[j++] = 92;
            }
            newStr[j++] = str.charAt(i);
        }
        return new String(newStr, 0, j);
    }

    private static boolean isMeta(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    static {
        mySyntax.put("jndi.syntax.direction", "left_to_right");
        mySyntax.put("jndi.syntax.separator", "/");
        mySyntax.put("jndi.syntax.escape", "\\");
    }

    static final class CNCompoundName
    extends CompoundName {
        private static final long serialVersionUID = -6599252802678482317L;

        CNCompoundName(Enumeration enum_) {
            super(enum_, mySyntax);
        }

        @Override
        public Object clone() {
            return new CNCompoundName(this.getAll());
        }

        @Override
        public Name getPrefix(int posn) {
            Enumeration<String> comps = super.getPrefix(posn).getAll();
            return new CNCompoundName(comps);
        }

        @Override
        public Name getSuffix(int posn) {
            Enumeration<String> comps = super.getSuffix(posn).getAll();
            return new CNCompoundName(comps);
        }

        @Override
        public String toString() {
            try {
                return CNNameParser.cosNameToInsString(CNNameParser.nameToCosName(this));
            }
            catch (InvalidNameException e) {
                return super.toString();
            }
        }
    }
}

