/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.dmr.ModelNode;

public class PullDownDataForServerConfigOnSlaveHandler
implements OperationStepHandler {
    public static String OPERATION_NAME = "slave-server-config-change";
    protected final String host;
    protected final Transformers transformers;
    protected final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;

    public PullDownDataForServerConfigOnSlaveHandler(String host, Transformers transformers, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.host = host;
        this.transformers = transformers;
        this.runtimeIgnoreTransformationRegistry = runtimeIgnoreTransformationRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        final IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverInfo = IgnoredNonAffectedServerGroupsUtil.createServerConfigInfo(operation.require("server"));
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        HashSet<PathElement> unknownElements = new HashSet<PathElement>();
        String serverGroupName = serverInfo.getServerGroup();
        PathElement serverGroupElement = PathElement.pathElement((String)"server-group", (String)serverGroupName);
        Resource serverGroupResource = root.getChild(serverGroupElement);
        if (serverGroupResource == null) {
            throw HostControllerMessages.MESSAGES.noResourceFor(PathAddress.pathAddress((PathElement[])new PathElement[]{serverGroupElement}));
        }
        String serverGroupSocketBindingGroup = null;
        if (!this.runtimeIgnoreTransformationRegistry.isServerGroupKnown(root, this.host, serverGroupName)) {
            unknownElements.add(serverGroupElement);
            ModelNode serverGroupModel = serverGroupResource.getModel();
            String profileName = serverGroupModel.get("profile").asString();
            PathElement profileElement = PathElement.pathElement((String)"profile", (String)profileName);
            Resource profileResource = root.getChild(profileElement);
            if (profileResource == null) {
                throw HostControllerMessages.MESSAGES.noResourceFor(PathAddress.pathAddress((PathElement[])new PathElement[]{profileElement}));
            }
            if (!this.runtimeIgnoreTransformationRegistry.isProfileKnown(root, this.host, profileName)) {
                unknownElements.add(profileElement);
                Set<PathElement> unknownExtensions = this.runtimeIgnoreTransformationRegistry.getUnknownExtensionsForProfile(root, this.host, profileName);
                unknownElements.addAll(unknownExtensions);
            }
            if (serverGroupModel.hasDefined("socket-binding-group")) {
                serverGroupSocketBindingGroup = serverGroupModel.get("socket-binding-group").asString();
                this.addSocketBindingGroup(unknownElements, root, serverGroupSocketBindingGroup);
            }
        }
        if (serverInfo.getSocketBindingGroup() != null && !serverInfo.getSocketBindingGroup().equals(serverGroupSocketBindingGroup)) {
            this.addSocketBindingGroup(unknownElements, root, serverInfo.getSocketBindingGroup());
        }
        final ReadMasterDomainModelUtil readUtil = ReadMasterDomainModelUtil.readMasterDomainResourcesForSlaveRequest(context, unknownElements, this.transformers, root, this.runtimeIgnoreTransformationRegistry);
        context.getResult().set(readUtil.getDescribedResources());
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    PullDownDataForServerConfigOnSlaveHandler.this.runtimeIgnoreTransformationRegistry.addKnownDataForSlave(PullDownDataForServerConfigOnSlaveHandler.this.host, readUtil.getNewKnownRootResources());
                    PullDownDataForServerConfigOnSlaveHandler.this.runtimeIgnoreTransformationRegistry.updateSlaveServerConfig(PullDownDataForServerConfigOnSlaveHandler.this.host, serverInfo);
                }
            }
        });
    }

    private void addSocketBindingGroup(Set<PathElement> unknownElements, Resource root, String socketBindingGroup) throws OperationFailedException {
        PathElement socketBindingGroupElement = PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroup);
        Resource socketBindingGroupResource = root.getChild(socketBindingGroupElement);
        if (socketBindingGroupResource == null) {
            throw HostControllerMessages.MESSAGES.noResourceFor(PathAddress.pathAddress((PathElement[])new PathElement[]{socketBindingGroupElement}));
        }
        if (!this.runtimeIgnoreTransformationRegistry.isSocketBindingGroupKnown(root, this.host, socketBindingGroup)) {
            unknownElements.add(socketBindingGroupElement);
        }
    }
}

