/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.domain.controller.DomainControllerLogger;

class ConcurrentUpdateTask
implements Runnable {
    private final List<Runnable> concurrentTasks;
    private final ExecutorService executorService;

    ConcurrentUpdateTask(List<Runnable> concurrentTasks, ExecutorService executorService) {
        this.concurrentTasks = concurrentTasks;
        this.executorService = executorService;
    }

    @Override
    public void run() {
        ArrayList futures = new ArrayList();
        Iterator<Runnable> i$ = this.concurrentTasks.iterator();
        while (i$.hasNext()) {
            Runnable r;
            final Runnable task = r = i$.next();
            futures.add(AccessController.doPrivileged(new PrivilegedAction<Future<?>>(){

                @Override
                public Future<?> run() {
                    return ConcurrentUpdateTask.this.executorService.submit(task);
                }
            }));
        }
        for (int i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            try {
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.caughtExceptionWaitingForTaskReturning(ConcurrentUpdateTask.class.getSimpleName(), e.getClass().getSimpleName(), this.concurrentTasks.get(i).toString());
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.caughtExceptionWaitingForTask(ConcurrentUpdateTask.class.getSimpleName(), e.getClass().getSimpleName(), this.concurrentTasks.get(i).toString());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConcurrentUpdateTask{tasks={");
        for (int i = 0; i < this.concurrentTasks.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.concurrentTasks.get(i).toString());
        }
        sb.append("}}");
        return sb.toString();
    }
}

