/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.dmr.ModelNode;

public class ExtensionRemoveHandler
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ExtensionRegistry extensionRegistry;

    public ExtensionRemoveHandler(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRemove(context, operation, model);
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String module = address.getLastElement().getValue();
        this.extensionRegistry.removeExtension(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), module);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    @Override
    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

