/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.undertow.SessionManagementBridge;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class ServletPreAuthActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(ServletPreAuthActionsHandler.class);
    protected HttpHandler next;
    protected UndertowUserSessionManagement userSessionManagement;
    protected AdapterDeploymentContext deploymentContext;

    protected ServletPreAuthActionsHandler(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, HttpHandler next) {
        this.next = next;
        this.deploymentContext = deploymentContext;
        this.userSessionManagement = userSessionManagement;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        UndertowHttpFacade facade = new UndertowHttpFacade(exchange);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        SessionManagementBridge bridge = new SessionManagementBridge(this.userSessionManagement, servletRequestContext.getDeployment().getSessionManager());
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)bridge, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.next.handleRequest(exchange);
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected AdapterDeploymentContext deploymentContext;
        protected UndertowUserSessionManagement userSessionManagement;

        public Wrapper(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement) {
            this.deploymentContext = deploymentContext;
            this.userSessionManagement = userSessionManagement;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new ServletPreAuthActionsHandler(this.deploymentContext, this.userSessionManagement, handler);
        }
    }
}

