/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionInt {
    private String name;
    private String longName;
    private String description;
    private boolean hasValue = true;
    private List<String> values;
    private String argument;
    private Class<?> type;
    private boolean required = false;
    private char valueSeparator;
    private boolean isProperty = false;
    private boolean hasMultipleValues = false;
    private Map<String, String> properties;

    public OptionInt(char name, String longName, String description, boolean hasValue, String argument, boolean required, char valueSeparator, boolean isProperty, boolean hasMultipleValues, Class<?> type) {
        this.name = String.valueOf(name);
        this.longName = longName;
        this.description = description;
        this.hasValue = hasValue;
        this.argument = argument;
        this.required = required;
        this.valueSeparator = valueSeparator;
        this.isProperty = isProperty;
        this.type = type;
        this.hasMultipleValues = hasMultipleValues;
        this.properties = new HashMap<String, String>();
        this.values = new ArrayList<String>();
        if (name == '\u0000' && longName.equals("")) {
            throw new IllegalArgumentException("Either name or long name must be set.");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.hasValue || this.hasMultipleValues;
    }

    public boolean hasMultipleValues() {
        return this.hasMultipleValues;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public String getArgument() {
        return this.argument;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void clean() {
        this.values.clear();
        this.properties.clear();
    }

    public int getFormattedLength() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("-").append(this.name);
        }
        if (this.longName != null) {
            if (sb.toString().trim().length() > 0) {
                sb.append(", ");
            }
            sb.append("--").append(this.longName);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        return sb.length();
    }

    public String getFormattedOption(int offset, int descriptionStart, int width) {
        StringBuilder sb = new StringBuilder();
        if (offset > 0) {
            sb.append(String.format("%" + offset + "s", ""));
        }
        if (this.name != null) {
            sb.append("-").append(this.name);
        }
        if (this.longName != null) {
            if (sb.toString().trim().length() > 0) {
                sb.append(", ");
            }
            sb.append("--").append(this.longName);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        if (this.description != null && this.description.length() > 0) {
            int descOffset = descriptionStart - this.getFormattedLength() - offset;
            if (descOffset > 0) {
                sb.append(String.format("%" + descOffset + "s", ""));
            } else {
                sb.append(" ");
            }
            sb.append(this.description);
        }
        return sb.toString();
    }
}

