/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.console.Config;

public class ParameterInt {
    private String name;
    private String usage;
    private Class<?> argumentType;
    private List<OptionInt> options;

    public ParameterInt(String name, String usage) {
        this.setName(name);
        this.setUsage(usage);
        this.setOptions(new ArrayList<OptionInt>());
    }

    public ParameterInt(String name, String usage, Class<?> argumentType) {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.setOptions(new ArrayList<OptionInt>());
    }

    public ParameterInt(String name, String usage, Class<?> argumentType, OptionInt[] options) {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.setOptions(Arrays.asList(options));
    }

    public ParameterInt(String name, String usage, Class<?> argumentType, List<OptionInt> options) {
        this.setName(name);
        this.setUsage(usage);
        this.setArgumentType(argumentType);
        this.setOptions(options);
    }

    public List<OptionInt> getOptions() {
        return this.options;
    }

    public void addOption(OptionInt option) {
        this.options.add(option);
    }

    public void addOption(char name, String longName, String description, boolean hasValue, String argument, boolean required, boolean hasMultipleValues, Class<?> type) {
        this.options.add(new OptionInt(name, longName, description, hasValue, argument, required, '\u0000', false, hasMultipleValues, type));
    }

    public void addOption(char name, String longName, String description, boolean hasValue) {
        this.addOption(name, longName, description, hasValue, null, false, false, null);
    }

    private void setOptions(List<OptionInt> options) {
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(Class<?> argumentType) {
        this.argumentType = argumentType;
    }

    public OptionInt findOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getName() == null || !option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt findLongOption(String name) {
        for (OptionInt option : this.options) {
            if (option.getLongName() == null || !option.getLongName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getName())) continue;
            return option;
        }
        return null;
    }

    public OptionInt startWithLongOption(String name) {
        for (OptionInt option : this.options) {
            if (!name.startsWith(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    public void clean() {
        for (OptionInt optionInt : this.options) {
            optionInt.clean();
        }
    }

    public List<String> getOptionLongNamesWithDash() {
        ArrayList<String> names = new ArrayList<String>(this.options.size());
        for (OptionInt o : this.options) {
            names.add("--" + o.getLongName());
        }
        return names;
    }

    public List<String> findPossibleLongNamesWitdDash(String name) {
        ArrayList<String> names = new ArrayList<String>(this.options.size());
        for (OptionInt o : this.options) {
            if (!o.getName().equals(name) && !o.getLongName().startsWith(name)) continue;
            names.add("--" + o.getLongName());
        }
        return names;
    }

    public String printHelp() {
        int maxLength = 0;
        int width = 80;
        for (OptionInt o : this.getOptions()) {
            if (o.getFormattedLength() <= maxLength) continue;
            maxLength = o.getFormattedLength();
        }
        StringBuilder sb = new StringBuilder();
        for (OptionInt o : this.getOptions()) {
            sb.append(o.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        return "Usage: " + this.getName() + " " + this.getUsage() + Config.getLineSeparator() + sb.toString();
    }
}

