/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.util.LoggerUtil;

public class FileUtils {
    private static Logger logger = LoggerUtil.getLogger(FileUtils.class.getName());

    public static void saveFile(File file, String text, boolean append) throws IOException {
        if (file.isDirectory()) {
            if (Settings.getInstance().isLogging()) {
                logger.info("Cannot save file " + file + ", it is a directory");
            }
            throw new IOException(file + ": Is a directory");
        }
        if (file.isFile()) {
            FileWriter fileWriter = append ? new FileWriter(file, true) : new FileWriter(file, false);
            fileWriter.write(text);
            fileWriter.flush();
            fileWriter.close();
        } else {
            FileWriter fileWriter = new FileWriter(file, false);
            fileWriter.write(text);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        if (file.isDirectory()) {
            if (Settings.getInstance().isLogging()) {
                logger.info("Cannot save file " + file + ", it is a directory");
            }
            throw new IOException(file + ": Is a directory");
        }
        if (file.isFile()) {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line).append(Config.getLineSeparator());
                    line = br.readLine();
                }
                String string = sb.toString();
                return string;
            }
            finally {
                br.close();
            }
        }
        if (Settings.getInstance().isLogging()) {
            logger.info("Cannot read file " + file + ", file unknown");
        }
        throw new IOException(file + ": File unknown");
    }
}

