/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.sso;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.security.sso.DistributableSingleSignOnManagerFactoryBuilder;
import org.wildfly.extension.undertow.security.sso.DistributableSingleSignOnManagerFactoryBuilderValue;
import org.wildfly.extension.undertow.security.sso.InMemorySingleSignOnManagerFactory;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManager;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManagerFactory;

public class SingleSignOnManagerService
implements Service<io.undertow.security.impl.SingleSignOnManager> {
    private final InjectedValue<SingleSignOnManagerFactory> factory = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private volatile SingleSignOnManager manager;

    public static ServiceBuilder<io.undertow.security.impl.SingleSignOnManager> build(ServiceTarget target, ServiceName name, ServiceName hostName) {
        ServiceName factoryName = name.append(new String[]{"factory"});
        DistributableSingleSignOnManagerFactoryBuilder builder = new DistributableSingleSignOnManagerFactoryBuilderValue().getValue();
        if (builder != null) {
            builder.build(target, factoryName, hostName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            InMemorySingleSignOnManagerFactory factory = new InMemorySingleSignOnManagerFactory();
            target.addService(factoryName, (Service)new ValueService((Value)new ImmediateValue((Object)factory)));
        }
        SingleSignOnManagerService service = new SingleSignOnManagerService();
        return target.addService(name, (Service)service).addDependency(factoryName, SingleSignOnManagerFactory.class, service.factory).addDependency(hostName, Host.class, service.host);
    }

    private SingleSignOnManagerService() {
    }

    public SingleSignOnManager getValue() {
        return this.manager;
    }

    public void start(StartContext context) {
        this.manager = ((SingleSignOnManagerFactory)this.factory.getValue()).createSingleSignOnManager((Host)this.host.getValue());
        this.manager.start();
    }

    public void stop(StopContext context) {
        this.manager.stop();
    }
}

