/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool;
import org.jboss.logging.Logger;

public class LeakDumperManagedConnectionPool
extends SemaphoreArrayListManagedConnectionPool {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)LeakDumperManagedConnectionPool.class.getName());
    private static boolean useFile = false;
    private static String leakFileName = null;
    private static Object leakLock = new Object();
    private final ConcurrentMap<ConnectionListener, Throwable> tracker = new ConcurrentHashMap<ConnectionListener, Throwable>();

    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ConnectionListener cl = super.getConnection(subject, cri);
        this.tracker.put(cl, new Throwable("ALLOCATION LEAK"));
        return cl;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill, boolean cleanup) {
        this.tracker.remove(cl);
        super.returnConnection(cl, kill, cleanup);
    }

    @Override
    void doDestroy(ConnectionListener cl) {
        if (this.tracker.containsKey(cl)) {
            Throwable t = (Throwable)this.tracker.get(cl);
            log.connectionLeak(this.getPoolName(), t);
            if (useFile) {
                this.dump(t);
            }
            this.tracker.remove(cl);
        }
        super.doDestroy(cl);
    }

    @Override
    public void shutdown() {
        if (this.tracker.size() > 0) {
            for (Throwable t : this.tracker.values()) {
                log.connectionLeak(this.getPoolName(), t);
                if (!useFile) continue;
                this.dump(t);
            }
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Throwable t) {
        Object object = leakLock;
        synchronized (object) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(leakFileName, true);
                PrintStream ps = new PrintStream(os, true);
                ps.print("Leak detected in pool: ");
                ps.println(this.getPoolName());
                t.printStackTrace(ps);
                ps.println();
                ps.flush();
            }
            catch (Exception e) {
                log.debug(e.getMessage(), e);
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LeakDumperManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[super=").append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    static {
        String f = SecurityActions.getSystemProperty("ironjacamar.leaklog");
        if (f != null && !f.trim().equals("")) {
            useFile = true;
            leakFileName = f;
        }
    }
}

