/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class TransactionImpl
implements Transaction,
Serializable {
    private static final long serialVersionUID = 3L;
    private transient Long key;
    private transient int status;
    private transient Set<Synchronization> syncs;
    private transient Map<Object, Object> resources;

    public TransactionImpl(Long key) {
        this.key = key;
        this.status = 0;
        this.syncs = null;
        this.resources = new HashMap<Object, Object>();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        if (this.status == 1) {
            throw new IllegalStateException("Status marked rollback");
        }
        this.finish(true);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("Status not valid");
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        if (this.syncs == null) {
            this.syncs = new HashSet<Synchronization>(1);
        }
        this.syncs.add(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        this.finish(false);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        this.status = 1;
    }

    boolean getRollbackOnly() {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        return this.status == 1;
    }

    void putResource(Object key, Object value) {
        this.resources.put(key, value);
    }

    Object getResource(Object key) {
        return this.resources.get(key);
    }

    Long getKey() {
        return this.key;
    }

    private void finish(boolean commit) {
        if (this.syncs != null) {
            for (Synchronization s : this.syncs) {
                s.beforeCompletion();
            }
        }
        this.status = commit ? 3 : 4;
        if (this.syncs != null) {
            for (Synchronization s : this.syncs) {
                s.afterCompletion(this.status);
            }
        }
        this.status = 5;
        if (this.syncs != null) {
            this.syncs = null;
        }
    }
}

