/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.jberet.services.ContextHandle;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityContextHandle
implements ContextHandle {
    private final SecurityContext securityContext = SecurityContextHandle.getSecurityContext();

    SecurityContextHandle() {
    }

    @Override
    public ContextHandle.Handle setup() {
        final SecurityContext current = SecurityContextHandle.getSecurityContext();
        SecurityContextHandle.setSecurityContext(this.securityContext);
        return new ContextHandle.Handle(){

            @Override
            public void tearDown() {
                SecurityContextHandle.setSecurityContext(current);
            }
        };
    }

    private static SecurityContext getSecurityContext() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return SecurityContextAssociation.getSecurityContext();
                }
            });
        }
        return SecurityContextAssociation.getSecurityContext();
    }

    private static void setSecurityContext(final SecurityContext securityContext) {
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    return null;
                }
            });
        } else {
            SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
        }
    }
}

