/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.VInt8IntEncoder;

public abstract class ChunksIntEncoder
extends IntEncoder {
    protected final int[] encodeQueue;
    protected int encodeQueueSize = 0;
    protected final IntEncoder encoder = new VInt8IntEncoder();
    protected int indicator = 0;
    protected byte ordinal = 0;

    protected ChunksIntEncoder(int chunkSize) {
        this.encodeQueue = new int[chunkSize];
    }

    protected void encodeChunk() throws IOException {
        this.out.write(this.indicator);
        for (int i = 0; i < this.encodeQueueSize; ++i) {
            this.encoder.encode(this.encodeQueue[i]);
        }
        this.encodeQueueSize = 0;
        this.ordinal = 0;
        this.indicator = 0;
    }

    public void close() throws IOException {
        if (this.ordinal != 0) {
            this.encodeChunk();
        }
        this.encoder.close();
        super.close();
    }

    public void reInit(OutputStream out) {
        this.encoder.reInit(out);
        super.reInit(out);
        this.ordinal = 0;
        this.indicator = 0;
        this.encodeQueueSize = 0;
    }
}

