/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.as.cli.handlers.ifelse.Operation;

abstract class BaseOperation
implements Operation,
Comparable<Operation> {
    private final String name;
    private final int priority;
    private final List<Operand> operands;

    BaseOperation(String name, int priority) {
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        this.name = name;
        this.priority = priority;
        this.operands = new ArrayList<Operand>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<Operand> getOperands() {
        return this.operands;
    }

    protected void addOperand(Operand operand) throws CommandLineException {
        if (operand == null) {
            throw new IllegalArgumentException("operand can't be null.");
        }
        this.operands.add(operand);
    }

    @Override
    public int compareTo(Operation o) {
        if (o == null) {
            throw new IllegalArgumentException("can't compare to null.");
        }
        return this.priority < o.getPriority() ? -1 : (this.priority > o.getPriority() ? 1 : 0);
    }

    public String toString() {
        return '(' + this.name + ' ' + this.operands + ')';
    }
}

