/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class AddressSettingRemove
extends AbstractRemoveStepHandler {
    static final OperationStepHandler INSTANCE = new AddressSettingRemove();

    AddressSettingRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HornetQServer server = AddressSettingRemove.getServer(context, operation);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            server.getAddressSettingsRepository().removeMatch(address.getLastElement().getValue());
        }
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

