/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SslHandshakeSniffingTransportWrapper
implements SslTransportWrapper {
    private final SslTransportWrapper _secureTransportWrapper;
    private final TransportWrapper _plainTransportWrapper;
    private boolean _determinationMade = false;
    private boolean _isSecure;

    SslHandshakeSniffingTransportWrapper(SslTransportWrapper secureTransportWrapper, TransportWrapper plainTransportWrapper) {
        this._secureTransportWrapper = secureTransportWrapper;
        this._plainTransportWrapper = plainTransportWrapper;
    }

    @Override
    public int input(byte[] sourceBuffer, int offset, int size) {
        if (!this._determinationMade) {
            byte[] zeroBasedSrcBytes = new byte[size];
            System.arraycopy(sourceBuffer, offset, zeroBasedSrcBytes, 0, size);
            this._isSecure = this.checkForSslHandshake(zeroBasedSrcBytes);
            this._determinationMade = true;
        }
        if (this._isSecure) {
            return this._secureTransportWrapper.input(sourceBuffer, offset, size);
        }
        return this._plainTransportWrapper.input(sourceBuffer, offset, size);
    }

    @Override
    public int output(byte[] destinationBuffer, int offset, int size) {
        if (!this._determinationMade) {
            this._isSecure = false;
            this._determinationMade = true;
        }
        if (this._isSecure) {
            return this._secureTransportWrapper.output(destinationBuffer, offset, size);
        }
        return this._plainTransportWrapper.output(destinationBuffer, offset, size);
    }

    @Override
    public String getCipherName() {
        return this._secureTransportWrapper.getCipherName();
    }

    @Override
    public String getProtocolName() {
        return this._secureTransportWrapper.getProtocolName();
    }

    private boolean checkForSslHandshake(byte[] buf) {
        if (buf.length >= 5) {
            boolean isSSL2Handshake = buf[2] == 1 && (buf[3] == 3 && buf[4] <= 3 || buf[3] == 2 && buf[4] == 0);
            boolean isSSL3Handshake = buf[0] == 22 && buf[1] == 3 && buf[2] <= 3;
            return isSSL2Handshake || isSSL3Handshake;
        }
        throw new IllegalArgumentException("Too few bytes (" + buf.length + ") to make SSL/plain  determination.");
    }
}

