/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.URLResource;

final class ClassLoaderLocalLoader
implements LocalLoader {
    static final ClassLoaderLocalLoader SYSTEM = new ClassLoaderLocalLoader(ClassLoaderLocalLoader.class.getClassLoader());
    private static final Method getPackage = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            for (Method method : ClassLoader.class.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals("getPackage") || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
                method.setAccessible(true);
                return method;
            }
            throw new IllegalStateException("No getPackage method found on ClassLoader");
        }
    });
    private final ClassLoader classLoader;

    ClassLoaderLocalLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        try {
            return Class.forName(name, resolve, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Package loadPackageLocal(String name) {
        try {
            return (Package)getPackage.invoke((Object)this.classLoader, name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error er) {
                throw er;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        Enumeration<URL> urls;
        ClassLoader classLoader = this.classLoader;
        try {
            urls = classLoader == null ? ClassLoader.getSystemResources(name) : classLoader.getResources(name);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            list.add(new URLResource(urls.nextElement()));
        }
        return list;
    }
}

