/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.weld.WeldMessages;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ModuleGroupSingletonProvider
extends SingletonProvider {
    public static final Map<ClassLoader, Set<ClassLoader>> deploymentClassLoaders = new ConcurrentHashMap<ClassLoader, Set<ClassLoader>>();

    public static void addClassLoaders(ClassLoader topLevel, Set<ClassLoader> allClassLoaders) {
        deploymentClassLoaders.put(topLevel, allClassLoaders);
    }

    public static void removeClassLoader(ClassLoader topLevel) {
        deploymentClassLoaders.remove(topLevel);
    }

    public <T> Singleton<T> create(Class<? extends T> type) {
        return new TCCLSingleton();
    }

    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private volatile Map<ClassLoader, T> store = Collections.emptyMap();
        private volatile Map<String, T> contextIdStore = Collections.emptyMap();

        private TCCLSingleton() {
        }

        public T get() {
            T instance = this.store.get(this.findParentModuleCl(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()));
            if (instance == null) {
                throw WeldMessages.MESSAGES.singletonNotSet(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
            }
            return instance;
        }

        public synchronized void set(T object) {
            IdentityHashMap<ClassLoader, T> store = new IdentityHashMap<ClassLoader, T>(this.store);
            ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            store.put(classLoader, object);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    store.put(cl, object);
                }
            }
            this.store = store;
        }

        public synchronized void clear() {
            ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            IdentityHashMap<ClassLoader, T> store = new IdentityHashMap<ClassLoader, T>(this.store);
            store.remove(classLoader);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    store.remove(cl);
                }
            }
            this.store = store;
        }

        public boolean isSet() {
            return this.store.containsKey(this.findParentModuleCl(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()));
        }

        private ClassLoader findParentModuleCl(ClassLoader classLoader) {
            ClassLoader c;
            for (c = classLoader; c != null && !(c instanceof ModuleClassLoader); c = c.getParent()) {
            }
            return c;
        }

        public T get(String id) {
            T val = this.contextIdStore.get(id);
            if (val != null) {
                return val;
            }
            return this.get();
        }

        public boolean isSet(String id) {
            T val = this.contextIdStore.get(id);
            if (val != null) {
                return true;
            }
            return this.isSet();
        }

        public synchronized void set(String id, T object) {
            this.set(object);
            HashMap<String, T> store = new HashMap<String, T>(this.contextIdStore);
            store.put(id, object);
            this.contextIdStore = store;
        }

        public synchronized void clear(String id) {
            this.clear();
            HashMap<String, T> store = new HashMap<String, T>(this.contextIdStore);
            store.remove(id);
            this.contextIdStore = store;
        }
    }
}

