/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.extension.authserver.AuthServerDefinition;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public abstract class AbstractAddOverlayHandler
implements OperationStepHandler {
    protected static final String UPLOADED_FILE_OP_NAME = "uploaded-file-name";
    protected static final SimpleAttributeDefinition BYTES_TO_UPLOAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bytes-to-upload", ModelType.BYTES, false).setAllowExpression(false)).setAllowNull(false)).build();
    static final SimpleAttributeDefinition REDEPLOY_SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redeploy", ModelType.BOOLEAN, true).setXmlName("redeploy")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition OVERWRITE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("overwrite", ModelType.BOOLEAN, true).setXmlName("overwrite")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String uploadFileName = operation.get(UPLOADED_FILE_OP_NAME).asString();
        boolean isRedeploy = AbstractAddOverlayHandler.isRedeploy(context, operation);
        boolean isOverwrite = AbstractAddOverlayHandler.getBooleanFromOperation(operation, OVERWRITE);
        String overlayPath = this.getOverlayPath(uploadFileName);
        String overlayName = AuthServerUtil.getOverlayName(operation);
        PathAddress overlayAddress = AuthServerUtil.getOverlayAddress(overlayName);
        String deploymentName = AuthServerUtil.getDeploymentName(operation);
        boolean isOverlayExists = AuthServerUtil.isOverlayExists(context, overlayName, PathAddress.EMPTY_ADDRESS);
        if (!isOverlayExists) {
            this.addOverlay(context, overlayAddress);
            if (!this.isHostController(context)) {
                this.addDeploymentToOverlay(context, overlayAddress, deploymentName);
            }
        }
        if (this.isHostController(context)) {
            this.addOverlayToServerGroups(context, overlayAddress, operation, overlayName);
        }
        if (isOverlayExists && this.isContentExists(context, overlayAddress, overlayPath)) {
            if (isOverwrite) {
                AbstractAddOverlayHandler.removeContent(context, overlayAddress, overlayPath);
            } else {
                throw new OperationFailedException(this.pathExistsMessage(overlayAddress, overlayPath));
            }
        }
        this.addContent(context, overlayAddress, operation.get(BYTES_TO_UPLOAD.getName()).asBytes(), overlayPath);
        if (isRedeploy) {
            AuthServerUtil.addStepToRedeployAuthServer(context, deploymentName);
        }
        if (!isRedeploy) {
            context.restartRequired();
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    static void removeContent(OperationContext context, PathAddress overlayAddress, String overlayPath) {
        PathAddress contentAddress = overlayAddress.append("content", overlayPath);
        ModelNode operation = Util.createRemoveOperation((PathAddress)contentAddress);
        context.addStep(operation, AuthServerUtil.getHandler(context, contentAddress, "remove"), OperationContext.Stage.MODEL);
    }

    static boolean isRedeploy(OperationContext context, ModelNode operation) {
        return AbstractAddOverlayHandler.isAuthServerEnabled(context) && AbstractAddOverlayHandler.getBooleanFromOperation(operation, REDEPLOY_SERVER);
    }

    private boolean isHostController(OperationContext context) {
        return context.getProcessType() == ProcessType.HOST_CONTROLLER;
    }

    private String pathExistsMessage(PathAddress overlayAddress, String overlayPath) {
        PathAddress contentAddress = overlayAddress.append("content", overlayPath);
        String msg = "Can not update overlay at " + contentAddress.toCLIStyleString();
        msg = msg + "  You may try your request again using the " + OVERWRITE.getName() + " attribute.";
        return msg;
    }

    private boolean isContentExists(OperationContext context, PathAddress overlayAddress, String overlayPath) {
        Resource resource = context.readResourceFromRoot(overlayAddress);
        return resource.getChildrenNames("content").contains(overlayPath);
    }

    private void addOverlay(OperationContext context, PathAddress overlayAddress) {
        ModelNode op = Util.createAddOperation((PathAddress)overlayAddress);
        this.doAddStep(context, overlayAddress, op);
    }

    private void addDeploymentToOverlay(OperationContext context, PathAddress overlayAddress, String deploymentName) {
        PathAddress deploymentAddress = overlayAddress.append("deployment", deploymentName);
        ModelNode op = Util.createAddOperation((PathAddress)deploymentAddress);
        this.doAddStep(context, deploymentAddress, op);
    }

    private void addOverlayToServerGroups(OperationContext context, PathAddress overlayAddress, ModelNode operation, String overlayName) {
        String myProfile = this.findMyProfile(operation);
        for (String serverGroup : this.getServerGroupNames(context)) {
            PathAddress address = PathAddress.pathAddress((String)"server-group", (String)serverGroup);
            ModelNode serverGroupModel = context.readResourceFromRoot(address).getModel();
            if (!serverGroupModel.get("profile").asString().equals(myProfile)) continue;
            PathAddress serverGroupOverlayAddress = address.append(overlayAddress);
            boolean isOverlayExists = AuthServerUtil.isOverlayExists(context, overlayName, address);
            if (isOverlayExists) continue;
            this.addOverlay(context, serverGroupOverlayAddress);
            this.addDeploymentToOverlay(context, serverGroupOverlayAddress, AuthServerUtil.getDeploymentName(operation));
        }
    }

    private String findMyProfile(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return address.getElement(0).getValue();
    }

    private Set<String> getServerGroupNames(OperationContext context) {
        return context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS).getChildrenNames("server-group");
    }

    private void addContent(OperationContext context, PathAddress overlayAddress, byte[] bytes, String overlayPath) throws OperationFailedException {
        PathAddress contentAddress = overlayAddress.append("content", overlayPath);
        ModelNode op = Util.createAddOperation((PathAddress)contentAddress);
        ModelNode content = new ModelNode();
        content.get("bytes").set(bytes);
        op.get("content").set(content);
        this.doAddStep(context, contentAddress, op);
    }

    private void doAddStep(OperationContext context, PathAddress address, ModelNode operation) {
        context.addStep(operation, AuthServerUtil.getHandler(context, address, "add"), OperationContext.Stage.MODEL);
    }

    private static boolean isAuthServerEnabled(OperationContext context) {
        String attrName;
        boolean defaultValue = AuthServerDefinition.ENABLED.getDefaultValue().asBoolean();
        ModelNode authServerModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        if (!authServerModel.get(attrName = AuthServerDefinition.ENABLED.getName()).isDefined()) {
            return defaultValue;
        }
        return authServerModel.get(attrName).asBoolean();
    }

    private static boolean getBooleanFromOperation(ModelNode operation, SimpleAttributeDefinition definition) {
        boolean defaultValue = definition.getDefaultValue().asBoolean();
        if (!operation.get(definition.getName()).isDefined()) {
            return defaultValue;
        }
        return operation.get(definition.getName()).asBoolean();
    }

    private ModelNode scrub(ModelNode op) {
        ModelNode scrubbed = op.clone();
        if (scrubbed.has("content")) {
            scrubbed.get("content").set("BYTES REMOVED FOR DISPLAY");
        }
        if (scrubbed.has("bytes-to-upload")) {
            scrubbed.get("bytes-to-upload").set("BYTES REMOVED FOR DISPLAY");
        }
        return scrubbed;
    }

    abstract String getOverlayPath(String var1);
}

