/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.extension.authserver.AbstractAddOverlayHandler;
import org.keycloak.subsystem.extension.authserver.AuthServerDefinition;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public class RemoveOverlayHandler
implements OperationStepHandler {
    static final String REMOVE_OVERLAY_OPERATION = "remove-overlay";
    protected static final SimpleAttributeDefinition OVERLAY_FILE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("overlay-file-path", ModelType.STRING, false).setAllowExpression(true)).setAllowNull(false)).setDefaultValue(new ModelNode().set("/WEB-INF/lib/myprovider.jar"))).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-overlay", AuthServerDefinition.rscDescriptionResolver).addParameter((AttributeDefinition)OVERLAY_FILE_PATH).addParameter((AttributeDefinition)AbstractAddOverlayHandler.REDEPLOY_SERVER).build();
    static final OperationStepHandler INSTANCE = new RemoveOverlayHandler();

    private RemoveOverlayHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String overlayName = AuthServerUtil.getOverlayName(operation);
        boolean isOverlayExists = AuthServerUtil.isOverlayExists(context, overlayName, PathAddress.EMPTY_ADDRESS);
        String overlayPath = operation.get(OVERLAY_FILE_PATH.getName()).asString();
        if (!isOverlayExists) {
            context.setRollbackOnly();
            throw new OperationFailedException("Overlay path " + overlayPath + " not found.");
        }
        PathAddress overlayAddress = AuthServerUtil.getOverlayAddress(overlayName);
        AbstractAddOverlayHandler.removeContent(context, overlayAddress, overlayPath);
        boolean isRedeploy = AbstractAddOverlayHandler.isRedeploy(context, operation);
        String deploymentName = AuthServerUtil.getDeploymentName(operation);
        if (isRedeploy) {
            AuthServerUtil.addStepToRedeployAuthServer(context, deploymentName);
        }
        if (!isRedeploy) {
            context.restartRequired();
        }
        context.stepCompleted();
    }
}

